/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.concurrent.atomic.AtomicLong;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyProvider;

public class DoublePropertyProvider
implements PropertyProvider<Double> {
    public final PropertyKey<Double> key;
    public final AtomicLong value;

    public DoublePropertyProvider(PropertyKey<Double> key) {
        this.key = key;
        this.value = new AtomicLong(Double.doubleToLongBits(key.getDefaultValue()));
    }

    public void reset() {
        this.value.set(Double.doubleToLongBits(this.key.getDefaultValue()));
    }

    @Override
    public Double get() {
        return Double.longBitsToDouble(this.value.get());
    }

    @Override
    public Double set(Double value) {
        return Double.longBitsToDouble(this.value.getAndSet(Double.doubleToLongBits(value)));
    }

    public String toString() {
        return Double.toString(Double.longBitsToDouble(this.value.get()));
    }
}

