/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.concurrent.atomic.AtomicLong;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyProvider;

public class LongPropertyProvider
implements PropertyProvider<Long> {
    public final PropertyKey<Long> key;
    public final AtomicLong value;

    public LongPropertyProvider(PropertyKey<Long> key) {
        this.key = key;
        this.value = new AtomicLong(key.getDefaultValue());
    }

    public void reset() {
        this.value.set(this.key.getDefaultValue().intValue());
    }

    public long increment() {
        return this.value.incrementAndGet();
    }

    public long longValue() {
        return this.value.get();
    }

    @Override
    public Long get() {
        return this.value.get();
    }

    @Override
    public Long set(Long value) {
        return this.value.getAndSet(value.intValue());
    }

    public String toString() {
        return this.value.toString();
    }
}

