/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.concurrent.atomic.AtomicBoolean;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyListener;
import org.jsoar.util.properties.PropertyManager;

public class PropertyListenerHandle<T> {
    private final PropertyManager manager;
    private final PropertyKey<T> key;
    private final PropertyListener<T> listener;
    private final AtomicBoolean added = new AtomicBoolean(true);

    PropertyListenerHandle(PropertyManager manager, PropertyKey<T> key, PropertyListener<T> listener) {
        this.manager = manager;
        this.key = key;
        this.listener = listener;
    }

    public void addListener() {
        if (!this.added.getAndSet(true)) {
            this.manager.addListener(this.key, this.listener);
        }
    }

    public void removeListener() {
        if (this.added.getAndSet(false)) {
            this.manager.removeListener(this.key, this.listener);
        }
    }
}

