/*
 * Decompiled with CFR 0.152.
 */
package org.jsoar.util.properties;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jsoar.util.properties.DefaultPropertyProvider;
import org.jsoar.util.properties.PropertyChangeEvent;
import org.jsoar.util.properties.PropertyKey;
import org.jsoar.util.properties.PropertyListener;
import org.jsoar.util.properties.PropertyListenerHandle;
import org.jsoar.util.properties.PropertyProvider;

public class PropertyManager {
    private final Map<PropertyKey<?>, PropertyProvider<?>> properties = Collections.synchronizedMap(new HashMap());
    private final Map<PropertyKey<?>, List<?>> listeners = Collections.synchronizedMap(new HashMap());

    public <T> PropertyListenerHandle<T> addListener(PropertyKey<T> key, PropertyListener<T> listener) {
        this.getListenersForKey(key).add(listener);
        return new PropertyListenerHandle<T>(this, key, listener);
    }

    public <T> void removeListener(PropertyKey<T> key, PropertyListener<T> listener) {
        this.getListenersForKey(key).remove(listener);
    }

    public <T> void setProvider(PropertyKey<T> key, PropertyProvider<T> provider) {
        this.properties.put(key, provider);
        this.firePropertyChanged(key, provider.get(), provider.get());
    }

    public <T> T get(PropertyKey<T> key) {
        return this.getProvider(key).get();
    }

    public List<PropertyKey<?>> getKeys() {
        return new ArrayList(this.properties.keySet());
    }

    public PropertyKey<?> getKey(String name) {
        for (PropertyKey<?> key : this.properties.keySet()) {
            if (!name.equals(key.getName())) continue;
            return key;
        }
        return null;
    }

    public <T, V extends T> T set(PropertyKey<T> key, V value) {
        if (key.isReadonly()) {
            throw new UnsupportedOperationException("property '" + key + "' is readonly");
        }
        T oldValue = this.getProvider(key).set(value);
        this.firePropertyChanged(key, value, oldValue);
        return oldValue;
    }

    public <T, V extends T> void firePropertyChanged(PropertyKey<T> key, V value, T oldValue) {
        PropertyChangeEvent<T> event = new PropertyChangeEvent<T>(key, oldValue, value);
        for (PropertyListener<T> listener : this.getListenersForKey(key)) {
            listener.propertyChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> PropertyProvider<T> getProvider(PropertyKey<T> key) {
        Map<PropertyKey<?>, PropertyProvider<?>> map = this.properties;
        synchronized (map) {
            PropertyProvider<?> provider = this.properties.get(key);
            if (provider == null) {
                provider = new DefaultPropertyProvider(key);
                this.properties.put(key, provider);
            }
            return provider;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> List<PropertyListener<T>> getListenersForKey(PropertyKey<T> key) {
        Map<PropertyKey<?>, List<?>> map = this.listeners;
        synchronized (map) {
            List<PropertyListener<T>> list = this.listeners.get(key);
            if (list == null) {
                list = new CopyOnWriteArrayList();
                this.listeners.put(key, list);
            }
            return list;
        }
    }
}

