/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support;

import com.github.softwarevax.support.application.SupportHolder;
import com.github.softwarevax.support.configure.SupportConstant;
import com.github.softwarevax.support.lock.configuration.LockConstant;
import com.github.softwarevax.support.method.aspect.MethodInterceptorAdvisor;
import com.github.softwarevax.support.method.configuration.MethodConstant;
import com.github.softwarevax.support.page.configuration.PaginationConstant;
import com.github.softwarevax.support.result.configuration.ResultConstant;
import org.aopalliance.aop.Advice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.util.Assert;

@ComponentScan(basePackages={"com.github.softwarevax.support"})
@EnableConfigurationProperties(value={SupportConstant.class, LockConstant.class, ResultConstant.class, PaginationConstant.class, MethodConstant.class})
public class SupportAutoConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger logger = LoggerFactory.getLogger(SupportAutoConfiguration.class);
    @Autowired
    private SupportConstant supportConstant;
    @Autowired
    private LockConstant lockConstant;
    @Autowired
    private ResultConstant resultConstant;
    @Autowired
    private PaginationConstant paginationConstant;
    @Autowired
    private MethodConstant methodConstant;

    @Bean
    @ConditionalOnProperty(value={"support.method.enable"}, havingValue="true")
    public DefaultPointcutAdvisor methodAdvisor() {
        Assert.hasText((String)this.methodConstant.getExpress(), (String)"\u8bf7\u914d\u7f6e\u5207\u70b9\u8868\u8fbe\u5f0f");
        MethodInterceptorAdvisor interceptor = new MethodInterceptorAdvisor();
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(this.methodConstant.getExpress());
        logger.info("method aop expression = {}", (Object)this.methodConstant.getExpress());
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)pointcut);
        advisor.setAdvice((Advice)interceptor);
        advisor.setOrder(this.methodConstant.getOrder());
        return advisor;
    }

    public void onApplicationEvent(ApplicationReadyEvent event) {
        SupportHolder holder = SupportHolder.getInstance();
        holder.setApplicationContext((ApplicationContext)event.getApplicationContext());
        holder.put("method_constant", this.methodConstant);
        holder.put("support_constant", this.supportConstant);
        holder.put("lock_constant", this.lockConstant);
        holder.put("result_constant", this.resultConstant);
        holder.put("pagination_constant", this.paginationConstant);
        holder.initializeLoaded();
        logger.info("[support]\u52a0\u8f7d\u5b8c\u6210");
    }
}

