/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.application;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Context {
    private Map<String, Object> parameters = new HashMap<String, Object>();

    public Context() {
    }

    public Context(Map<String, Object> parameters) {
        this();
        if (parameters != null) {
            this.parameters = parameters;
        }
    }

    public void clear() {
        if (this.parameters.size() > 0) {
            this.parameters.clear();
        }
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        if (this.parameters.containsKey(key)) {
            return "true".equals(this.parameters.get(key));
        }
        return defaultValue;
    }

    public Integer getInteger(String key) {
        return this.getInteger(key, null);
    }

    public Integer getInteger(String key, Integer defaultValue) {
        if (this.parameters.containsKey(key)) {
            try {
                return (Integer)this.parameters.get(key);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return defaultValue;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long defaultValue) {
        if (this.parameters.containsKey(key)) {
            try {
                return (Long)this.parameters.get(key);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return defaultValue;
    }

    public <T> T get(String key) {
        return (T)this.parameters.get(key);
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        if (this.parameters.containsKey(key)) {
            return null == this.parameters.get(key) ? defaultValue : (String)this.parameters.get(key);
        }
        return defaultValue;
    }

    public void put(String key, Object value, boolean override) {
        if (override) {
            this.parameters.put(key, value);
        }
    }

    public void put(String key, Object value) {
        this.put(key, value, true);
    }

    public void putAll(Map<String, Object> map) {
        this.parameters.putAll(map);
    }

    public List<Object> getPrefix(String ... prefix) {
        ArrayList<Object> prefixObjs = new ArrayList<Object>();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            String key = entry.getKey();
            for (String pre : prefix) {
                if (pre == null || pre.equals("") || !key.startsWith(pre)) continue;
                prefixObjs.add(entry.getValue());
            }
        }
        return prefixObjs;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            sb.append(entry.getKey()).append(":").append(entry.getValue()).append(";");
        }
        return sb.toString();
    }
}

