/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.application;

import com.github.softwarevax.support.SupportAutoConfiguration;
import com.github.softwarevax.support.application.SupportContext;
import com.github.softwarevax.support.configure.SupportConstant;
import com.github.softwarevax.support.configure.ThreadPoolDemander;
import com.github.softwarevax.support.method.aspect.MethodInterceptorAdvisor;
import com.github.softwarevax.support.method.aspect.MethodInvokeNoticer;
import com.github.softwarevax.support.method.aspect.PersistenceMethodInvokeNoticer;
import com.github.softwarevax.support.method.aspect.advice.DefaultExpressMethodAdvice;
import com.github.softwarevax.support.method.bean.WebInterface;
import com.github.softwarevax.support.method.configuration.MethodConstant;
import com.github.softwarevax.support.utils.HttpServletUtils;
import com.github.softwarevax.support.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class SupportHolder {
    private static final Logger logger = LoggerFactory.getLogger(SupportAutoConfiguration.class);
    private static SupportHolder holder;
    private ThreadPoolTaskExecutor executor;
    private ApplicationContext springCtx;
    private SupportContext supportCtx = new SupportContext();
    private Map<String, WebInterface> interfaceMaps;

    public static SupportHolder getInstance() {
        if (Objects.isNull(holder)) {
            holder = new SupportHolder();
        }
        return holder;
    }

    private SupportHolder() {
        this.supportCtx.put("init_finish", false);
    }

    public ThreadPoolTaskExecutor getThreadPoolExecutor() {
        return this.executor;
    }

    public void setApplicationContext(ApplicationContext springCtx) {
        this.springCtx = springCtx;
    }

    public ApplicationContext getApplicationContext() {
        return this.springCtx;
    }

    public void put(String key, Object obj) {
        this.supportCtx.put(key, obj);
    }

    public <T> T get(String key) {
        return this.supportCtx.get(key);
    }

    public Map<String, WebInterface> getInterfaces() {
        return this.interfaceMaps;
    }

    public <T> List<T> getBeans(Class<T> clazz) {
        Map beansOfType = this.springCtx.getBeansOfType(clazz);
        return new ArrayList(beansOfType.values());
    }

    public void initializeLoaded() {
        if (((Boolean)this.supportCtx.get("init_finish")).booleanValue()) {
            return;
        }
        this.initCommon();
        this.initMethod();
        this.supportCtx.put("init_finish", true);
    }

    private void initCommon() {
        String[] beanNamesForType;
        ThreadPoolTaskExecutor executor = null;
        try {
            executor = (ThreadPoolTaskExecutor)this.springCtx.getBean(ThreadPoolTaskExecutor.class);
        }
        catch (Exception e) {
            logger.warn("\u5e94\u7528\u672a\u5b9a\u4e49\u7ebf\u7a0b\u6c60\uff0c\u521b\u5efa\u9ed8\u8ba4\u7ebf\u7a0b\u6c60");
        }
        if (Objects.isNull(executor)) {
            SupportConstant supportConstant = (SupportConstant)this.supportCtx.get("support_constant");
            executor = supportConstant.getThreadPool().threadPoolExecutor();
        }
        this.executor = executor;
        for (String beanName : beanNamesForType = this.springCtx.getBeanNamesForType(ThreadPoolDemander.class)) {
            ThreadPoolDemander bean = (ThreadPoolDemander)this.springCtx.getBean(beanName, ThreadPoolDemander.class);
            bean.setThreadPoolTaskExecutor(executor);
        }
        this.interfaceMaps = HttpServletUtils.getAllInterfaces(this.springCtx);
        String applicationName = StringUtils.getFirstNotBlank(StringUtils.strip((String)this.springCtx.getApplicationName(), (String)"/"), this.springCtx.getId());
        this.supportCtx.put("application_name", applicationName);
    }

    private void initMethod() {
        DefaultPointcutAdvisor advisor = (DefaultPointcutAdvisor)this.springCtx.getBean(DefaultPointcutAdvisor.class);
        MethodInterceptorAdvisor advice = (MethodInterceptorAdvisor)advisor.getAdvice();
        DefaultExpressMethodAdvice defaultAdvice = new DefaultExpressMethodAdvice();
        MethodConstant constant = (MethodConstant)this.supportCtx.get("method_constant");
        defaultAdvice.setExpress(constant.getExpress());
        advice.register(defaultAdvice);
        List<Class<? extends MethodInvokeNoticer>> noticerClazz = constant.getNoticers();
        List<MethodInvokeNoticer> noticers = noticerClazz.stream().map(row -> (MethodInvokeNoticer)BeanUtils.instantiateClass((Class)row)).collect(Collectors.toList());
        if (constant.getPersistence().booleanValue()) {
            PersistenceMethodInvokeNoticer noticer = new PersistenceMethodInvokeNoticer();
            noticer.setTemplate((JdbcTemplate)this.springCtx.getBean(JdbcTemplate.class));
            noticer.checkTable(constant);
            noticers.add(noticer);
        }
        defaultAdvice.addNoticers(noticers);
        defaultAdvice.setThreadPoolTaskExecutor(this.executor);
    }

    public <T> T registerBean(String name, Class<T> clazz, Object ... args) {
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)this.springCtx;
        if (this.springCtx.containsBean(name)) {
            Object bean = this.springCtx.getBean(name);
            if (bean.getClass().isAssignableFrom(clazz)) {
                return (T)bean;
            }
            throw new RuntimeException("BeanName \u91cd\u590d " + name);
        }
        BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
        for (Object arg : args) {
            beanDefinitionBuilder.addConstructorArgValue(arg);
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)ctx.getBeanFactory();
        beanFactory.registerBeanDefinition(name, (BeanDefinition)beanDefinition);
        return (T)this.springCtx.getBean(name, clazz);
    }
}

