/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.configure;

import com.github.softwarevax.support.configure.DefaultThreadFactory;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class ThreadPoolConfiguration {
    private int coreSize = Runtime.getRuntime().availableProcessors();
    private int maxSize = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private int capacity = 100;
    private int keepAlive = 300;
    private RejectedExecutionHandler handler = new ThreadPoolExecutor.CallerRunsPolicy();
    private ThreadPoolTaskExecutor executor;

    public int getCoreSize() {
        return this.coreSize;
    }

    public void setCoreSize(int coreSize) {
        this.coreSize = coreSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(int keepAlive) {
        this.keepAlive = keepAlive;
    }

    public RejectedExecutionHandler getHandler() {
        return this.handler;
    }

    public ThreadPoolTaskExecutor threadPoolExecutor() {
        if (this.executor == null) {
            ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
            threadPoolTaskExecutor.setCorePoolSize(this.getCoreSize());
            threadPoolTaskExecutor.setMaxPoolSize(this.getMaxSize());
            threadPoolTaskExecutor.setQueueCapacity(this.getCapacity());
            threadPoolTaskExecutor.setKeepAliveSeconds(this.getKeepAlive());
            threadPoolTaskExecutor.setRejectedExecutionHandler(this.getHandler());
            threadPoolTaskExecutor.setThreadFactory((ThreadFactory)new DefaultThreadFactory());
            threadPoolTaskExecutor.initialize();
            return threadPoolTaskExecutor;
        }
        return this.executor;
    }
}

