/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.lock.aspect;

import com.github.softwarevax.support.configure.ThreadPoolDemander;
import com.github.softwarevax.support.lock.configuration.Lock;
import com.github.softwarevax.support.lock.configuration.LockConstant;
import com.github.softwarevax.support.lock.configuration.enums.LockEnum;
import com.github.softwarevax.support.lock.service.LockService;
import com.github.softwarevax.support.lock.service.impl.DatabaseLockServiceImpl;
import com.github.softwarevax.support.lock.service.impl.RedisLockServiceImpl;
import java.lang.reflect.Method;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
@ConditionalOnProperty(name={"support.lock.enable"}, havingValue="true")
public class DistributeLockAspect
implements SmartInitializingSingleton,
ApplicationContextAware,
ThreadPoolDemander {
    private static final Logger logger = LoggerFactory.getLogger(DistributeLockAspect.class);
    private static final String LOCK_SERVICE_NAME = "lockService";
    private ThreadPoolTaskExecutor executor;
    private ThreadLocal<String> lockKey = new ThreadLocal();
    private LockService lockService;
    @Autowired
    private LockConstant constant;

    @Before(value="@annotation(com.github.softwarevax.support.lock.configuration.Lock)")
    public void doBefore(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (method == null) {
            return;
        }
        Lock lock = method.getAnnotation(Lock.class);
        long timeOut = lock.timeout();
        String key = lock.key();
        String keyName = this.getLockKey(key, joinPoint);
        this.lockKey.set(keyName);
        try {
            logger.info("lockKey = {}", (Object)keyName);
            Future future = this.executor.submit(() -> this.lockService.lock(keyName, timeOut));
            boolean aBoolean = (Boolean)future.get(timeOut, TimeUnit.MILLISECONDS);
            Assert.isTrue((boolean)aBoolean, (String)"\u5206\u5e03\u5f0f\u9501\u83b7\u53d6\u5931\u8d25");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Around(value="@annotation(com.github.softwarevax.support.lock.configuration.Lock)")
    public Object around(ProceedingJoinPoint proceedingJoinPoint) {
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @After(value="@annotation(com.github.softwarevax.support.lock.configuration.Lock)")
    public void after(JoinPoint joinPoint) {
    }

    @AfterReturning(pointcut="@annotation(com.github.softwarevax.support.lock.configuration.Lock)", returning="ret")
    public void doAfterReturning(Object ret) {
        String key = this.lockKey.get();
        this.executor.submit(() -> this.lockService.unLock(key));
        this.lockKey.remove();
    }

    @AfterThrowing(pointcut="@annotation(com.github.softwarevax.support.lock.configuration.Lock)", throwing="ex")
    public void AfterThrowing(JoinPoint joinPoint, Throwable ex) {
        String key = this.lockKey.get();
        this.executor.submit(() -> this.lockService.unLock(key));
        this.lockKey.remove();
    }

    private String getLockKey(String key, JoinPoint joinPoint) {
        String[] names;
        if (StringUtils.isNotBlank((CharSequence)key)) {
            return key;
        }
        logger.info(key);
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        for (String name : names = StringUtils.split((String)method.toString(), (String)" ")) {
            if (StringUtils.indexOf((CharSequence)name, (CharSequence)"(") <= -1 || StringUtils.indexOf((CharSequence)name, (CharSequence)")") <= -1) continue;
            return name;
        }
        return null;
    }

    public void afterSingletonsInstantiated() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)applicationContext;
        BeanDefinitionBuilder beanDefinitionBuilder = null;
        LockEnum lockType = this.constant.getType();
        Assert.notNull((Object)((Object)lockType), (String)"\u8bf7\u914d\u7f6e\u5206\u5e03\u5f0f\u9501\u7c7b\u578b\uff1alock.type");
        logger.info("\u5206\u5e03\u5f0f\u9501\u7c7b\u578b = {}", (Object)lockType.name());
        Class clazz = null;
        switch (lockType) {
            case Redis: {
                Object[] args;
                clazz = RedisLockServiceImpl.class;
                beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
                RedisTemplate template = (RedisTemplate)ctx.getBean("redisTemplate");
                Assert.notNull((Object)template, (String)"RedisTemplate \u672a\u914d\u7f6e");
                for (Object arg : args = new Object[]{template, this.constant}) {
                    beanDefinitionBuilder.addConstructorArgValue(arg);
                }
                break;
            }
            case Oracle: 
            case MySQL: {
                Object[] args;
                clazz = DatabaseLockServiceImpl.class;
                beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition(clazz);
                RedisTemplate template = (JdbcTemplate)ctx.getBean(JdbcTemplate.class);
                Assert.notNull((Object)template, (String)"JdbcTemplate \u672a\u914d\u7f6e");
                for (Object arg : args = new Object[]{template, this.constant}) {
                    beanDefinitionBuilder.addConstructorArgValue(arg);
                }
                break;
            }
        }
        AbstractBeanDefinition beanDefinition = beanDefinitionBuilder.getRawBeanDefinition();
        BeanDefinitionRegistry beanFactory = (BeanDefinitionRegistry)ctx.getBeanFactory();
        beanFactory.registerBeanDefinition(LOCK_SERVICE_NAME, (BeanDefinition)beanDefinition);
        this.lockService = (LockService)ctx.getBean(LockService.class);
        logger.info("{} \u6ce8\u518c\u5b8c\u6210", (Object)LOCK_SERVICE_NAME);
    }

    @Override
    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }
}

