/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.lock.service.impl;

import com.github.softwarevax.support.lock.aspect.Item;
import com.github.softwarevax.support.lock.configuration.LockConstant;
import com.github.softwarevax.support.lock.service.LockService;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DatabaseLockServiceImpl
implements LockService {
    private static final Logger logger = LoggerFactory.getLogger(DatabaseLockServiceImpl.class);
    private static final String INSERT_SQL = "insert into distribute_lock(lock_key, lock_val, create_time) values(?, ?, ?)";
    private static final String DELETE_SQL = "delete from distribute_lock where lock_key = ?";
    private static final String TRUNCATE_SQL = "delete from distribute_lock";
    private JdbcTemplate template;
    private LockConstant constant;
    private List<Item> keys = new CopyOnWriteArrayList<Item>();

    public DatabaseLockServiceImpl() {
    }

    public DatabaseLockServiceImpl(JdbcTemplate template, LockConstant constant) {
        this.template = template;
        this.constant = constant;
        this.template.update(TRUNCATE_SQL);
        new Thread(() -> {
            while (true) {
                try {
                    block3: while (true) {
                        long sleepTime = 100L;
                        if (CollectionUtils.isEmpty(this.keys)) {
                            sleepTime = constant.getExpired();
                        }
                        TimeUnit.MILLISECONDS.sleep(sleepTime);
                        Iterator<Item> iterator = this.keys.iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block3;
                            Item item = iterator.next();
                            if (System.currentTimeMillis() <= item.getTime()) continue;
                            this.keys.remove(item);
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    continue;
                }
                break;
            }
        }).start();
    }

    @Override
    public boolean lock(String lockKey, long timeOut) {
        Assert.hasText((String)lockKey, (String)"lockKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((timeOut > 0L ? 1 : 0) != 0, (String)"timeOut\u5fc5\u987b\u5927\u4e8e0");
        try {
            String key = this.constant.getPrefix() + lockKey;
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            Object[] args = new Object[3];
            args[0] = key;
            args[1] = 1;
            this.keys.add(new Item(lockKey, System.currentTimeMillis() + this.constant.getExpired()));
            while (end - start <= timeOut) {
                args[2] = System.currentTimeMillis();
                try {
                    this.template.setQueryTimeout(1);
                    if (this.template.update(INSERT_SQL, args) > 0) {
                        return true;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                TimeUnit.MILLISECONDS.sleep(this.constant.getRetryInterval());
            }
            return false;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean unLock(String lockKey) {
        boolean success;
        Assert.hasText((String)lockKey, (String)"lockKey \u4e0d\u80fd\u4e3a\u7a7a");
        String key = this.constant.getPrefix() + lockKey;
        Object[] args = new Object[]{key};
        boolean bl = success = this.template.update(DELETE_SQL, args) > 0;
        if (success) {
            this.keys.remove(new Item(lockKey, 0L));
        }
        return success;
    }
}

