/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.lock.service.impl;

import com.github.softwarevax.support.lock.configuration.LockConstant;
import com.github.softwarevax.support.lock.service.LockService;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public class RedisLockServiceImpl
implements LockService {
    private RedisTemplate template;
    private LockConstant constant;

    public RedisLockServiceImpl() {
    }

    public RedisLockServiceImpl(RedisTemplate template, LockConstant constant) {
        this.template = template;
        this.constant = constant;
    }

    @Override
    public boolean lock(String lockKey, long timeOut) {
        Assert.hasText((String)lockKey, (String)"lockKey\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((timeOut > 0L ? 1 : 0) != 0, (String)"timeOut\u5fc5\u987b\u5927\u4e8e0");
        try {
            String key = this.constant.getPrefix() + lockKey;
            long start = System.currentTimeMillis();
            long end = System.currentTimeMillis();
            while (end - start <= timeOut) {
                if (this.template.opsForValue().setIfAbsent((Object)key, (Object)1, Duration.ofMillis(this.constant.getExpired())).booleanValue()) {
                    return true;
                }
                TimeUnit.MILLISECONDS.sleep(this.constant.getRetryInterval());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean unLock(String lockKey) {
        Assert.hasText((String)lockKey, (String)"lockKey \u4e0d\u80fd\u4e3a\u7a7a");
        String key = this.constant.getPrefix() + lockKey;
        return this.template.delete((Object)key);
    }
}

