/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.method.aspect;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.softwarevax.support.application.SupportHolder;
import com.github.softwarevax.support.method.aspect.MethodInvokeNoticer;
import com.github.softwarevax.support.method.bean.DynamicInfoMethod;
import com.github.softwarevax.support.method.bean.InvokeMethod;
import com.github.softwarevax.support.method.bean.MethodInterface;
import com.github.softwarevax.support.method.bean.MethodInterfaceInvoke;
import com.github.softwarevax.support.method.bean.MethodPo;
import com.github.softwarevax.support.method.bean.WebInterface;
import com.github.softwarevax.support.method.configuration.MethodConstant;
import com.github.softwarevax.support.utils.StringUtils;
import java.lang.reflect.AnnotatedElement;
import java.sql.PreparedStatement;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;

public class PersistenceMethodInvokeNoticer
implements MethodInvokeNoticer {
    private Logger logger = LoggerFactory.getLogger(PersistenceMethodInvokeNoticer.class);
    private Map<String, MethodPo> methodMaps = new HashMap<String, MethodPo>();
    private JdbcTemplate template;
    private Lock lock = new ReentrantLock();

    @Override
    public void callBack(InvokeMethod method) {
        block5: {
            Assert.notNull((Object)this.template, (String)"JdbcTemplate\u83b7\u53d6\u5931\u8d25");
            MethodPo staticInfo = this.getMethodStaticInfo(method);
            if (!this.methodMaps.containsKey(staticInfo.getFullMethodName())) {
                this.lock.lock();
                try {
                    if (this.methodMaps.containsKey(staticInfo.getFullMethodName())) break block5;
                    this.methodMaps.put(staticInfo.getFullMethodName(), staticInfo);
                }
                finally {
                    this.lock.unlock();
                }
                this.insertMethod(staticInfo);
                this.insertMethodInterface(method, staticInfo.getId());
            }
        }
        DynamicInfoMethod methodDynamicInfo = this.getMethodDynamicInfo(method);
        this.insertMethodInvoke(methodDynamicInfo);
        this.insertMethodInterfaceInvoke(method, methodDynamicInfo.getId());
    }

    private MethodPo getMethodStaticInfo(InvokeMethod method) {
        MethodPo po = new MethodPo();
        MethodConstant constant = (MethodConstant)SupportHolder.getInstance().get("method_constant");
        Class<AnnotatedElement> methodTag = constant.getMethodTag();
        if (method.getAnnotations().containsKey(methodTag)) {
            Map<String, Object> annotationMap = method.getAnnotations().get(methodTag);
            po.setMethodNTag(StringUtils.getFirstNotBlank(String.valueOf(annotationMap.get("value")), String.valueOf(annotationMap.get("name"))));
        }
        po.setApplication(method.getApplication());
        po.setLaunchTime(method.getLaunchTime());
        po.setExpose(method.getExpose());
        po.setMethod(method.getMethodName());
        po.setFullMethodName(method.getFullMethodName());
        po.setReturnType(method.getReturnType());
        po.setParameter(method.getArg());
        return po;
    }

    private DynamicInfoMethod getMethodDynamicInfo(InvokeMethod method) {
        DynamicInfoMethod dynamicInfo = new DynamicInfoMethod();
        dynamicInfo.setElapsedTime(method.getElapsedTime());
        dynamicInfo.setInvokeId(method.getInvokeId());
        dynamicInfo.setExpose(method.getExpose());
        dynamicInfo.setStartTime(new Date(method.getStartTime()));
        MethodPo methodPo = this.methodMaps.get(method.getFullMethodName());
        dynamicInfo.setSessionId(method.getSessionId());
        dynamicInfo.setMethodId(methodPo.getId());
        String parameter = this.getParameter(method.getArgs(), method.getArgsObj());
        if (StringUtils.length((CharSequence)parameter) > 4000) {
            parameter = StringUtils.substring((String)parameter, (int)0, (int)4000);
        }
        dynamicInfo.setParameterVal(parameter);
        String returnVal = JSON.toJSONString((Object)method.getReturnObj());
        if (StringUtils.length((CharSequence)returnVal) > 4000) {
            returnVal = StringUtils.substring((String)returnVal, (int)0, (int)4000);
        }
        dynamicInfo.setReturnVal(returnVal);
        dynamicInfo.setSessionId(method.getSessionId());
        return dynamicInfo;
    }

    public void setTemplate(JdbcTemplate template) {
        this.template = template;
    }

    public boolean checkTable(MethodConstant constant) {
        try {
            this.template.execute("select 1 from t_method where 1 = 0");
            this.template.execute("select 1 from t_method_invoke where 1 = 0");
            this.template.execute("select 1 from t_method_interface where 1 = 0");
            this.template.execute("select 1 from t_method_interface_invoke where 1 = 0");
            if (constant.getResetEveryTime().booleanValue()) {
                this.template.execute("truncate table t_method");
                this.template.execute("truncate table t_method_invoke");
                this.template.execute("truncate table t_method_interface");
                this.template.execute("truncate table t_method_interface_invoke");
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private String getParameter(String[] argNames, Object[] argValues) {
        JSONObject obj = new JSONObject();
        Assert.isTrue((ArrayUtils.getLength((Object)argNames) == ArrayUtils.getLength((Object)argValues) ? 1 : 0) != 0, (String)"\u53c2\u6570\u540d\u548c\u53c2\u6570\u503c\u6570\u91cf\u4e0d\u5339\u914d");
        int length = ArrayUtils.getLength((Object)argNames);
        for (int i = 0; i < length; ++i) {
            obj.put(argNames[i], argValues[i]);
        }
        return obj.toJSONString();
    }

    public boolean insertMethod(MethodPo po) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Object[] sqlArgs = po.getSQLArgs();
        int rowNum = this.template.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("insert into t_method(application, launch_time, expose, method, method_tag, full_method_name, return_type, parameter) values(?, ?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setObject(1, sqlArgs[0]);
            ps.setObject(2, sqlArgs[1]);
            ps.setObject(4, sqlArgs[3]);
            ps.setObject(3, sqlArgs[2]);
            ps.setObject(5, sqlArgs[4]);
            ps.setObject(6, sqlArgs[5]);
            ps.setObject(7, sqlArgs[6]);
            ps.setObject(8, sqlArgs[7]);
            return ps;
        }, (KeyHolder)keyHolder);
        po.setId(keyHolder.getKey().intValue());
        return rowNum > 0;
    }

    public boolean insertMethodInterface(InvokeMethod method, int methodId) {
        if (!method.getExpose().booleanValue()) {
            return false;
        }
        MethodInterface methodInterface = new MethodInterface();
        WebInterface interfaces = method.getInterfaces();
        String methods = interfaces.getMapping().getMethodsCondition().getMethods().stream().map(row -> row.name()).collect(Collectors.joining(","));
        methodInterface.setMethod(methods);
        PatternsRequestCondition pattern = interfaces.getMapping().getPatternsCondition();
        String mappings = pattern.getPatterns().stream().collect(Collectors.joining(","));
        methodInterface.setMappings(mappings);
        methodInterface.setMethodId(methodId);
        int rowNum = this.template.update("insert into t_method_interface(method_id, method, mappings) values(?, ?, ?)", methodInterface.getSQLArgs());
        return rowNum > 0;
    }

    public boolean insertMethodInvoke(DynamicInfoMethod dynamicInfo) {
        GeneratedKeyHolder keyHolder = new GeneratedKeyHolder();
        Object[] sqlArgs = dynamicInfo.getSQLArgs();
        int rowNum = this.template.update(connection -> {
            PreparedStatement ps = connection.prepareStatement("insert into t_method_invoke(session_id, invoke_id, method_id, expose, parameter_val, return_val, start_time, elapsed_time) values(?, ?, ?, ?, ?, ?, ?, ?)", 1);
            ps.setObject(2, sqlArgs[1]);
            ps.setObject(1, sqlArgs[0]);
            ps.setObject(3, sqlArgs[2]);
            ps.setObject(4, sqlArgs[3]);
            ps.setObject(5, sqlArgs[4]);
            ps.setObject(6, sqlArgs[5]);
            ps.setObject(7, sqlArgs[6]);
            ps.setObject(8, sqlArgs[7]);
            return ps;
        }, (KeyHolder)keyHolder);
        dynamicInfo.setId(keyHolder.getKey().intValue());
        return rowNum > 0;
    }

    public boolean insertMethodInterfaceInvoke(InvokeMethod method, int invokeId) {
        if (!method.getExpose().booleanValue()) {
            return false;
        }
        MethodInterfaceInvoke interfaceInvoke = method.getInterfaceInvoke();
        interfaceInvoke.setInvokeId(invokeId);
        int rowNum = this.template.update("insert into t_method_interface_invoke(invoke_id, scheme, method, remote_addr, headers, payload, response_status, response_body) values(?, ?, ?, ?, ?, ?, ?, ?)", interfaceInvoke.getSQLArgs());
        return rowNum > 0;
    }
}

