/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.method.aspect.advice;

import com.github.softwarevax.support.application.SupportHolder;
import com.github.softwarevax.support.configure.ThreadPoolDemander;
import com.github.softwarevax.support.method.aspect.MethodInvokeNoticer;
import com.github.softwarevax.support.method.aspect.advice.AbstractExpressMethodAdvice;
import com.github.softwarevax.support.method.bean.InvokeMethod;
import com.github.softwarevax.support.method.bean.InvokeStackInfo;
import com.github.softwarevax.support.method.bean.MethodInterfaceInvoke;
import com.github.softwarevax.support.method.bean.WebInterface;
import com.github.softwarevax.support.utils.CommonUtils;
import com.github.softwarevax.support.utils.HttpServletUtils;
import com.github.softwarevax.support.utils.IdWorker;
import com.github.softwarevax.support.utils.StringUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class DefaultExpressMethodAdvice
implements AbstractExpressMethodAdvice,
ThreadPoolDemander {
    private static final Logger logger = LoggerFactory.getLogger(DefaultExpressMethodAdvice.class);
    private LocalVariableTableParameterNameDiscoverer parameterNameDiscover = new LocalVariableTableParameterNameDiscoverer();
    private List<MethodInvokeNoticer> noticers = new ArrayList<MethodInvokeNoticer>();
    private ThreadLocal<Stack<StopWatch>> stopWatch = new ThreadLocal();
    private ThreadLocal<InvokeStackInfo> invoke = new ThreadLocal();
    private ThreadPoolTaskExecutor executor;
    private String express;

    @Override
    public void before(MethodInvocation invocation) {
        Stack<Object> stack;
        if (Objects.isNull(this.stopWatch.get())) {
            stack = new Stack();
            this.stopWatch.set(stack);
        }
        stack = this.stopWatch.get();
        StopWatch watch = new StopWatch();
        watch.start();
        stack.add(watch);
        MethodInterfaceInvoke interfaceInvoke = this.getMethodInterfaceInvokeFromServlet();
        this.invoke.set(new InvokeStackInfo(interfaceInvoke, HttpServletUtils.getSessionId(), IdWorker.getId()));
    }

    @Override
    public void afterReturn(Object obj, MethodInvocation invocation) {
        InvokeStackInfo invokeStackInfo = this.invoke.get();
        invokeStackInfo.setReturnObj(obj);
    }

    @Override
    public void after(MethodInvocation invocation) {
        Stack<StopWatch> stack = this.stopWatch.get();
        StopWatch watch = stack.pop();
        if (CollectionUtils.isEmpty(this.noticers)) {
            return;
        }
        Assert.notNull((Object)this.executor, (String)"\u7ebf\u7a0b\u6c60\u672a\u6210\u529f\u521d\u59cb\u5316");
        InvokeStackInfo invokeStackInfo = this.invoke.get();
        long elapsedTime = watch.getTime();
        this.executor.execute(() -> {
            InvokeMethod invokeMethod = this.parseMethod(invocation, invokeStackInfo.getReturnObj());
            invokeMethod.setStartTime(watch.getStartTime());
            invokeMethod.setInvokeId(invokeStackInfo.getInvokeId());
            invokeMethod.setSessionId(invokeStackInfo.getSessionId());
            invokeMethod.setElapsedTime(elapsedTime);
            invokeMethod.setInterfaceInvoke(invokeStackInfo.getInterfaceInvoke());
            this.noticers.stream().forEach(row -> row.callBack(invokeMethod));
        });
    }

    @Override
    public void throwException(MethodInvocation invocation, Throwable e) {
    }

    @Override
    public String getExpress() {
        return this.express;
    }

    @Override
    public void setExpress(String express) {
        if (StringUtils.isNotBlank((CharSequence)this.express)) {
            return;
        }
        this.express = express;
    }

    @Override
    public void addNoticer(MethodInvokeNoticer noticer) {
        this.noticers.add(noticer);
    }

    private InvokeMethod parseMethod(MethodInvocation invocation, Object ret) {
        InvokeMethod invokeMethod = new InvokeMethod();
        Method method = invocation.getMethod();
        Map<Class, Map<String, Object>> methodAnnotation = this.getMethodAnnotation(method);
        invokeMethod.setAnnotations(methodAnnotation);
        String returnType = method.getReturnType().getCanonicalName();
        String fullMethodName = CommonUtils.getMethodName(method);
        invokeMethod.setExpose(false);
        SupportHolder holder = SupportHolder.getInstance();
        Map<String, WebInterface> interfaces = holder.getInterfaces();
        if (interfaces.containsKey(fullMethodName)) {
            invokeMethod.setExpose(true);
            invokeMethod.setInterfaces(interfaces.get(fullMethodName));
        }
        String argument = StringUtils.substring((String)fullMethodName, (int)(StringUtils.indexOf((CharSequence)fullMethodName, (CharSequence)"(") + 1), (int)StringUtils.indexOf((CharSequence)fullMethodName, (CharSequence)")"));
        invokeMethod.setArgs(this.parameterNameDiscover.getParameterNames(method));
        invokeMethod.setArg(argument);
        invokeMethod.setMethodName(method.getName());
        invokeMethod.setFullMethodName(fullMethodName);
        invokeMethod.setReturnObj(ret);
        Object invokeObj = invocation.getThis();
        Object[] arguments = invocation.getArguments();
        invokeMethod.setArgsObj(arguments);
        invokeMethod.setInvokeObj(invokeObj);
        invokeMethod.setReturnType(returnType);
        invokeMethod.setLaunchTime((String)holder.get("launch_time"));
        invokeMethod.setApplication((String)holder.get("application_name"));
        return invokeMethod;
    }

    private MethodInterfaceInvoke getMethodInterfaceInvokeFromServlet() {
        MethodInterfaceInvoke interfaceInvoke = new MethodInterfaceInvoke();
        interfaceInvoke.setMethod(HttpServletUtils.getMethod());
        interfaceInvoke.setHeaders(HttpServletUtils.getHeaders());
        interfaceInvoke.setRemoteAddr(HttpServletUtils.remoteAddress());
        interfaceInvoke.setSchema(HttpServletUtils.getSchema());
        interfaceInvoke.setResponseStatus(HttpServletUtils.getResponseStatus());
        return interfaceInvoke;
    }

    private Map<Class, Map<String, Object>> getMethodAnnotation(Method method) {
        Annotation[] annotations;
        HashMap<Class, Map<String, Object>> map = new HashMap<Class, Map<String, Object>>();
        for (Annotation annotation : annotations = AnnotationUtils.getAnnotations((Method)method)) {
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)annotation);
            map.put(annotation.annotationType(), annotationAttributes);
        }
        return map;
    }

    @Override
    public void setThreadPoolTaskExecutor(ThreadPoolTaskExecutor executor) {
        this.executor = executor;
    }
}

