/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.page;

import com.github.pagehelper.PageHelper;
import com.github.softwarevax.support.utils.StringUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class OrderByInterceptor
implements Interceptor {
    public static Logger logger = LoggerFactory.getLogger(OrderByInterceptor.class);
    private static ThreadLocal<String> threadOrders = new ThreadLocal();

    public static void setOrderBy(String orderBy) {
        threadOrders.set(orderBy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        String orders = threadOrders.get();
        if (StringUtils.isBlank((CharSequence)orders)) {
            return invocation.proceed();
        }
        try {
            MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
            List resultMaps = mappedStatement.getResultMaps();
            if (CollectionUtils.isEmpty((Collection)resultMaps)) {
                Object object = invocation.proceed();
                return object;
            }
            ResultMap resultMap = (ResultMap)resultMaps.get(0);
            List resultMappings = resultMap.getResultMappings();
            Map<Object, Object> propertyColumnMap = new HashMap();
            if (CollectionUtils.isEmpty((Collection)resultMappings)) {
                Object parameter = invocation.getArgs()[1];
                BoundSql boundSql = mappedStatement.getBoundSql(parameter);
                String sql = boundSql.getSql();
                propertyColumnMap = this.getSelectColumn(sql, resultMap.getType());
            } else {
                List propertyResultMappings = resultMap.getPropertyResultMappings();
                propertyColumnMap = propertyResultMappings.stream().filter(row -> StringUtils.isNotEmpty((CharSequence)row.getColumn())).collect(Collectors.toMap(ResultMapping::getProperty, ResultMapping::getColumn));
            }
            String orderBy = this.parsePropertyToColumn(orders, propertyColumnMap);
            if (StringUtils.isBlank((CharSequence)orderBy)) {
                invocation.proceed();
            }
            PageHelper.orderBy((String)orderBy);
        }
        finally {
            threadOrders.remove();
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private Map<String, String> getSelectColumn(String sql, Class<?> type) throws JSQLParserException {
        Map<String, String> map = this.getColumn(type);
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect selectBody = (PlainSelect)select.getSelectBody();
        List selectItems = selectBody.getSelectItems();
        int size = selectItems.size();
        for (int i = 0; i < size; ++i) {
            SelectItem item = (SelectItem)selectItems.get(i);
            if (!(item instanceof SelectExpressionItem)) continue;
            SelectExpressionItem expressionItem = (SelectExpressionItem)item;
            String columnName = "";
            Alias alias = expressionItem.getAlias();
            Expression expression = expressionItem.getExpression();
            if (expression instanceof CaseExpression || expression instanceof TimeKeyExpression) {
                columnName = alias.getName();
            } else if (expression instanceof LongValue || expression instanceof StringValue || expression instanceof DateValue || expression instanceof DoubleValue) {
                columnName = Objects.nonNull(alias.getName()) ? alias.getName() : expression.getASTNode().jjtGetValue().toString();
            } else if (alias != null) {
                columnName = alias.getName();
            } else {
                SimpleNode node = expression.getASTNode();
                Object value = node.jjtGetValue();
                if (value instanceof Column) {
                    columnName = ((Column)value).getColumnName();
                } else if (value instanceof Function) {
                    columnName = value.toString();
                } else {
                    columnName = String.valueOf(value);
                    columnName = columnName.replace("'", "");
                    columnName = columnName.replace("\"", "");
                    columnName = columnName.replace("`", "");
                }
            }
            if (!map.containsKey(StringUtils.lowerCase((String)columnName))) continue;
            String property = map.get(StringUtils.lowerCase((String)columnName));
            map.put(property, columnName);
        }
        return map;
    }

    private Map<String, String> getColumn(Class<?> type) {
        HashMap<String, String> columnMap = new HashMap<String, String>();
        Field[] fields = FieldUtils.getAllFields(type);
        int size = fields.length;
        for (int i = 0; i < size; ++i) {
            columnMap.put(StringUtils.lowerCase((String)fields[i].getName()), fields[i].getName());
            columnMap.put(StringUtils.lowerCase((String)StringUtils.toUnderScoreCase(fields[i].getName())), fields[i].getName());
        }
        return columnMap;
    }

    private String parsePropertyToColumn(String orderBy, Map<String, String> propertyColumnMap) {
        List<String> propertyOrderBy = StringUtils.splitToList(orderBy, ",");
        if (CollectionUtils.isEmpty(propertyOrderBy)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Map<String, String> propertyOrderByMap = StringUtils.splitToMap(propertyOrderBy, " ");
        Iterator<Map.Entry<String, String>> iterator = propertyOrderByMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            String property = next.getKey();
            String order = next.getValue();
            Assert.isTrue((boolean)propertyColumnMap.containsKey(property), (String)("\u5c5e\u6027[" + property + "]\u6ca1\u6709\u6620\u5c04\u7684\u5217"));
            String columnAlias = propertyColumnMap.get(property);
            sb.append(columnAlias).append(" ").append(order);
            if (!iterator.hasNext()) continue;
            sb.append(",");
        }
        logger.info("orderBy = {}", (Object)sb);
        return sb.toString();
    }
}

