/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.page.aspect;

import com.github.pagehelper.PageHelper;
import com.github.softwarevax.support.page.OrderByInterceptor;
import com.github.softwarevax.support.page.Pagination;
import com.github.softwarevax.support.page.configuration.PaginationConstant;
import com.github.softwarevax.support.utils.HttpServletUtils;
import com.github.softwarevax.support.utils.StringUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Aspect
@Component
@ConditionalOnProperty(value={"support.page.enable"}, havingValue="true")
public class PaginationAspect
implements SmartInitializingSingleton {
    public static Logger logger = LoggerFactory.getLogger(PaginationAspect.class);
    @Autowired
    private PaginationConstant constant;
    @Autowired
    private SqlSessionFactory sqlSessionFactory;

    @Pointcut(value="@annotation(com.github.softwarevax.support.page.Pagination)")
    public void pagination() {
    }

    @Before(value="pagination()")
    public void doBefore(JoinPoint point) {
        if (!this.checkRequestValid()) {
            return;
        }
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        Pagination annotation = method.getAnnotation(Pagination.class);
        String pageSize = this.pageValue(annotation.pageSize(), this.constant.getPageSize());
        String pageNum = this.pageValue(annotation.pageNum(), this.constant.getPageNum());
        String orderBy = this.pageValue(annotation.orderBy(), this.constant.getOrderBy());
        int userDefineMaxPageSize = annotation.maxPageSize();
        boolean skipIfMissing = annotation.skipIfMissing();
        Map<String, Object> parameterMap = HttpServletUtils.compositeMap();
        if (this.returnIfMissing(parameterMap.containsKey(pageSize), skipIfMissing, pageSize)) {
            return;
        }
        if (this.returnIfMissing(parameterMap.containsKey(pageNum), skipIfMissing, pageNum)) {
            return;
        }
        Integer pageSizeVal = this.parseInt(parameterMap.get(pageSize));
        Integer pageNumVal = this.parseInt(parameterMap.get(pageNum));
        if (this.returnIfMissing(!Objects.isNull(pageSizeVal) && pageSizeVal > 0, skipIfMissing, pageSize)) {
            return;
        }
        if (this.returnIfMissing(!Objects.isNull(pageNumVal) && pageNumVal > 0, skipIfMissing, pageNum)) {
            return;
        }
        Integer maxPageSize = this.constant.getMaxPageSize();
        if (userDefineMaxPageSize > 0) {
            maxPageSize = userDefineMaxPageSize;
        }
        if (maxPageSize != null && maxPageSize > 0) {
            Assert.isTrue((pageSizeVal <= maxPageSize ? 1 : 0) != 0, (String)("\u5206\u9875\u5927\u5c0f\u4e0d\u5f97\u5927\u4e8e" + maxPageSize));
        }
        if (parameterMap.containsKey(orderBy)) {
            String order = String.valueOf(parameterMap.get(orderBy));
            OrderByInterceptor.setOrderBy(order);
        }
        PageHelper.startPage((int)pageNumVal, (int)pageSizeVal);
    }

    @AfterReturning(returning="ret", pointcut="pagination()")
    public void doAfterReturning(Object ret) {
        if (this.constant.getClearPage().booleanValue()) {
            PageHelper.clearPage();
        }
    }

    @AfterThrowing(value="pagination()", throwing="e")
    public void myAfterThrowing(Throwable e) {
        if (this.constant.getClearPage().booleanValue()) {
            PageHelper.clearPage();
        }
    }

    private boolean checkRequestValid() {
        MediaType contentType;
        String method = HttpServletUtils.getMethod();
        return !"POST".equals(method) || (contentType = HttpServletUtils.getRequestContentType()).equals((Object)MediaType.APPLICATION_FORM_URLENCODED) || contentType.equals((Object)MediaType.APPLICATION_JSON);
    }

    private String pageValue(String userDefined, String defaultValue) {
        if (StringUtils.isBlank((CharSequence)userDefined)) {
            return defaultValue;
        }
        return userDefined;
    }

    private Integer parseInt(Object obj) {
        if (obj == null) {
            return null;
        }
        String str = String.valueOf(obj);
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private boolean returnIfMissing(boolean availableParameter, boolean skipIfMissing, String parameterName) {
        if (availableParameter) {
            return false;
        }
        Assert.isTrue((boolean)skipIfMissing, (String)("\u53c2\u6570\u540d[" + parameterName + "]\u6ca1\u6709\u627e\u5230\u6216\u65e0\u6548"));
        return true;
    }

    public void afterSingletonsInstantiated() {
        this.sqlSessionFactory.getConfiguration().addInterceptor((Interceptor)new OrderByInterceptor());
    }
}

