/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.result;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.github.softwarevax.support.result.IResult;

public class ResultDto<T>
implements IResult<ResultDto> {
    private boolean flag;
    private T data;
    private String message;
    private int code;

    @Override
    public String returnString(Object obj) {
        return ResultDto.success(obj);
    }

    @Override
    public <T> T returnDto(Object obj) {
        return (T)ResultDto.successT(obj);
    }

    private ResultDto() {
    }

    public ResultDto(boolean flag, T data, int code, String message) {
        this.flag = flag;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public static <T> String result(boolean flag, T data, int code, String message) {
        ResultDto<T> resultDto = new ResultDto<T>();
        resultDto.flag = flag;
        resultDto.data = data;
        resultDto.code = code;
        resultDto.message = message;
        return JSON.toJSONString(resultDto, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullStringAsEmpty});
    }

    public static String result(boolean flag, int code, String message) {
        return ResultDto.result(flag, null, code, message);
    }

    public static String result(boolean flag) {
        Status status = flag ? Status.SUCCESS : Status.FAIL;
        return ResultDto.result(flag, null, status.code, status.message);
    }

    public static <T> String success(T data, int code, String message) {
        return ResultDto.result(true, data, code, message);
    }

    public static <T> String success(T data, String message) {
        return ResultDto.result(true, data, Status.SUCCESS.code, message);
    }

    public static <T> String success(T data) {
        return ResultDto.success(data, Status.SUCCESS.message);
    }

    public static String success() {
        return ResultDto.success(null, Status.SUCCESS.message);
    }

    public static String success(String message) {
        return ResultDto.success(null, message);
    }

    public static <T> String fail(T data, int code, String message) {
        return ResultDto.result(false, data, code, message);
    }

    public static <T> String fail(T data, String message) {
        return ResultDto.result(false, data, Status.FAIL.code, message);
    }

    public static <T> String fail(T data) {
        return ResultDto.fail(data, Status.FAIL.message);
    }

    public static String fail(String message) {
        return ResultDto.fail(null, message);
    }

    public static String fail() {
        return ResultDto.fail(null, Status.FAIL.message);
    }

    public boolean isFlag() {
        return this.flag;
    }

    public void setFlag(boolean flag) {
        this.flag = flag;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public static <T> ResultDto<T> successT(T data) {
        ResultDto<T> resultDto = new ResultDto<T>();
        resultDto.data = data;
        resultDto.flag = true;
        resultDto.code = Status.SUCCESS.code;
        resultDto.message = Status.SUCCESS.message;
        return resultDto;
    }

    public static <T> ResultDto<T> failT(T data) {
        ResultDto<T> resultDto = new ResultDto<T>();
        resultDto.data = data;
        resultDto.flag = false;
        resultDto.code = Status.FAIL.code;
        resultDto.message = Status.FAIL.message;
        return resultDto;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static enum Status {
        SUCCESS(200, "\u63a5\u53e3\u8c03\u7528\u6210\u529f"),
        FAIL(500, "\u63a5\u53e3\u8c03\u7528\u5931\u8d25");

        private String message;
        private int code;

        private Status(int code, String message) {
            this.code = code;
            this.message = message;
        }

        public String message() {
            return this.message;
        }

        public int code() {
            return this.code;
        }
    }
}

