/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.result.aspect;

import com.github.softwarevax.support.result.IResult;
import com.github.softwarevax.support.result.annotation.IgnoreResultWrapper;
import com.github.softwarevax.support.result.configuration.ResultConstant;
import java.lang.reflect.AnnotatedElement;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice
@ConditionalOnProperty(name={"support.result.enable"}, havingValue="true")
public class ResultAspect
implements ResponseBodyAdvice<Object> {
    @Autowired
    private ResultConstant constant;

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        AnnotatedElement annotatedElement = methodParameter.getAnnotatedElement();
        IgnoreResultWrapper ignoreResultWrapper = (IgnoreResultWrapper)AnnotationUtils.findAnnotation((AnnotatedElement)annotatedElement, IgnoreResultWrapper.class);
        return ignoreResultWrapper == null;
    }

    public Object beforeBodyWrite(Object o, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        IResult result = (IResult)BeanUtils.instantiateClass(this.constant.getWrapperImpl());
        if (o instanceof String) {
            return result.returnString(o);
        }
        if (IResult.class.isAssignableFrom(this.constant.getWrapperImpl())) {
            return o;
        }
        return result.returnDto(o);
    }
}

