/*
 * Decompiled with CFR 0.152.
 */
package com.github.softwarevax.support.utils;

import com.alibaba.fastjson.JSON;
import com.github.softwarevax.support.method.bean.WebInterface;
import com.github.softwarevax.support.utils.CommonUtils;
import com.github.softwarevax.support.utils.StringUtils;
import java.io.BufferedReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class HttpServletUtils {
    public static HttpServletRequest getRequest() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getRequest();
    }

    public static HttpServletResponse getResponse() {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        return requestAttributes.getResponse();
    }

    public static String getSessionId() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return request.getSession().getId();
    }

    public static String getQueryString() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        String queryString = request.getQueryString();
        return queryString;
    }

    public static Map<String, String> getMapFromQueryString() {
        String queryString = HttpServletUtils.getQueryString();
        List<String> splits = StringUtils.splitToList(queryString, "&");
        return StringUtils.splitToMap(splits, "=");
    }

    public static MediaType getRequestContentType() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return MediaType.valueOf((String)request.getContentType());
    }

    public static Map<String, String> getParameter() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpServletRequest request = HttpServletUtils.getRequest();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = request.getParameter(parameterName);
            result.put(parameterName, parameterValue);
        }
        return result;
    }

    public static String remoteAddress() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return request.getRemoteAddr() + ":" + request.getRemotePort();
    }

    public static String getSchema() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return request.getScheme();
    }

    public static int getResponseStatus() {
        HttpServletResponse response = HttpServletUtils.getResponse();
        return response.getStatus();
    }

    public static Map<String, String> getHeaders() {
        HashMap<String, String> result = new HashMap<String, String>();
        HttpServletRequest request = HttpServletUtils.getRequest();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            String headerValue = request.getHeader(headerName);
            result.put(headerName, headerValue);
        }
        return result;
    }

    public static Map<String, Object> getMapFromBodyJson() {
        StringBuilder sb = new StringBuilder();
        try {
            String str;
            HttpServletRequest request = HttpServletUtils.getRequest();
            BufferedReader br = request.getReader();
            while ((str = br.readLine()) != null) {
                sb.append(str);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sb.length() == 0 ? new HashMap() : JSON.parseObject((String)sb.toString());
    }

    public static Map<String, Object> compositeMap() {
        Map<String, String> mapFromQueryString = HttpServletUtils.getMapFromQueryString();
        Map<String, String> parameter = HttpServletUtils.getParameter();
        Map<String, Object> mapFromBodyJson = HttpServletUtils.getMapFromBodyJson();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.putAll(mapFromQueryString);
        map.putAll(parameter);
        map.putAll(mapFromBodyJson);
        return map;
    }

    public static String getMethod() {
        HttpServletRequest request = HttpServletUtils.getRequest();
        return request.getMethod();
    }

    public static Map<String, WebInterface> getAllInterfaces(ApplicationContext ctx) {
        HashMap<String, WebInterface> map = new HashMap<String, WebInterface>();
        String[] beanNamesForType = ctx.getBeanNamesForType(RequestMappingHandlerMapping.class);
        if (ArrayUtils.getLength((Object)beanNamesForType) <= 0) {
            return new HashMap<String, WebInterface>();
        }
        RequestMappingHandlerMapping mappings = (RequestMappingHandlerMapping)ctx.getBean("requestMappingHandlerMapping", RequestMappingHandlerMapping.class);
        Map handlerMethods = mappings.getHandlerMethods();
        for (Map.Entry next : handlerMethods.entrySet()) {
            RequestMappingInfo key = (RequestMappingInfo)next.getKey();
            HandlerMethod value = (HandlerMethod)next.getValue();
            String methodName = CommonUtils.getMethodName(value.getMethod());
            map.put(methodName, new WebInterface(key, value));
        }
        return map;
    }
}

