/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.layout.editor;

import java.beans.PropertyEditorSupport;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.lang.Nullable;

public class LocalDateEditor
extends PropertyEditorSupport {
    protected static final Log log = LogFactory.getLog(LocalDateEditor.class);
    private DateTimeFormatter formatter;

    public LocalDateEditor() {
        this.formatter = DateTimeFormatter.BASIC_ISO_DATE;
    }

    public LocalDateEditor(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public void setAsText(@Nullable String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            this.setValue(null);
        } else {
            this.setValue(LocalDate.parse(text, this.formatter));
        }
    }

    @Override
    public String getAsText() {
        LocalDate value = (LocalDate)this.getValue();
        return value != null ? this.formatter.format(value) : "";
    }
}

