/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.layout.editor;

import java.beans.PropertyEditorSupport;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class LocalDateTimeEditor
extends PropertyEditorSupport {
    private DateTimeFormatter formatter;

    public LocalDateTimeEditor() {
        this.formatter = DateTimeFormatter.BASIC_ISO_DATE;
    }

    public LocalDateTimeEditor(String pattern) {
        this.formatter = DateTimeFormatter.ofPattern(pattern);
    }

    @Override
    public void setAsText(@Nullable String text) {
        if (!StringUtils.hasText((String)text)) {
            this.setValue(null);
        } else {
            this.setValue(LocalDateTime.parse(text, this.formatter));
        }
    }

    @Override
    public String getAsText() {
        LocalDateTime value = (LocalDateTime)this.getValue();
        return value != null ? this.formatter.format(value) : "";
    }
}

