/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.writer.composite;

import java.beans.PropertyEditor;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.transform.FieldExtractor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class CompositeFlatFileFieldExtractor<T>
implements FieldExtractor<T>,
InitializingBean {
    protected static final Log log = LogFactory.getLog(CompositeFlatFileFieldExtractor.class);
    private FieldExtractor<T> fieldExtractor;
    private Map<Class<?>, PropertyEditor> customEditors;

    public void setFieldExtractor(FieldExtractor<T> fieldExtractor) {
        this.fieldExtractor = fieldExtractor;
    }

    public void setCustomEditors(Map<Class<?>, PropertyEditor> customEditors) {
        this.customEditors = customEditors;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.fieldExtractor, (String)"The 'fieldExtractor' property must be set.");
    }

    public Object[] extract(T object) {
        Object[] fields = this.fieldExtractor.extract(object);
        return this.format(fields);
    }

    private Object[] format(Object[] fields) {
        return Arrays.asList(fields).stream().map(f -> this.format(f)).collect(Collectors.toList()).toArray(new Object[fields.length]);
    }

    private Object format(Object field) {
        PropertyEditor editor;
        PropertyEditor propertyEditor = editor = this.customEditors != null && field != null ? this.customEditors.get(field.getClass()) : null;
        if (editor != null) {
            editor.setValue(field);
            return editor.getAsText();
        }
        if (field != null) {
            return field;
        }
        return "";
    }
}

