/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.excel.reader;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.batch.item.file.transform.DefaultFieldSetFactory;
import org.springframework.batch.item.file.transform.FieldSet;
import org.springframework.batch.item.file.transform.FieldSetFactory;

public class ExcelRowTokenizer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private FieldSetFactory fieldSetFactory = new DefaultFieldSetFactory();
    private String[] names;

    public void setNames(String[] names) {
        this.names = names;
    }

    public FieldSet tokenize(List<String> row, int rowNumber) {
        List<String> columns = row.stream().collect(Collectors.toList());
        String[] values = columns.toArray(new String[columns.size()]);
        if (values != null && this.names != null && this.names.length > values.length) {
            throw new RuntimeException("Error tokenizing row: " + rowNumber + " name count " + this.names.length + " and field value count " + values.length + "  don't match ");
        }
        if (this.names == null) {
            return this.fieldSetFactory.create(values);
        }
        return this.fieldSetFactory.create(values, this.names);
    }

    private void logFields(List<String> values, String[] names) {
        for (String name : names) {
            this.log.info((Object)("Name: " + name));
        }
        for (String value : values) {
            this.log.info((Object)("Value: " + value));
        }
    }
}

