/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.excel.reader;

import com.github.sourcegroove.batch.item.file.excel.reader.ExcelItemReader;
import com.github.sourcegroove.batch.item.file.excel.reader.ExcelRowMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class SimpleExcelItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ExcelItemReader<T> {
    protected final Log log = LogFactory.getLog(this.getClass());
    private Resource resource;
    private ExcelRowMapper<T> rowMapper;
    private int linesToSkip = 0;
    private Set<Integer> sheetsToRead;
    private Workbook workbook;
    private InputStream workbookStream;
    private Sheet sheet;
    private Iterator<Row> rowIterator;
    private int sheetIndex = -1;
    private int rowNumber = -1;
    private FormulaEvaluator formulaEvaluator;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.BASIC_ISO_DATE;

    public SimpleExcelItemReader() {
        this.setName(ClassUtils.getShortName(this.getClass()));
    }

    protected T doRead() throws Exception {
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            return this.readNextRow();
        }
        return this.readNextSheet();
    }

    protected void doOpen() throws Exception {
        Assert.isTrue((boolean)this.resource.exists(), (String)"resource does not exist");
        Assert.isTrue((boolean)this.resource.isReadable(), (String)"resource is not readable");
        try {
            this.workbookStream = this.resource.getInputStream();
            if (!this.workbookStream.markSupported() && !(this.workbookStream instanceof PushbackInputStream)) {
                throw new IllegalStateException("InputStream MUST either support mark/reset, or be wrapped as a PushbackInputStream");
            }
            this.workbook = WorkbookFactory.create((InputStream)this.workbookStream);
            this.workbook.setMissingCellPolicy(Row.MissingCellPolicy.CREATE_NULL_AS_BLANK);
            this.formulaEvaluator = this.workbook.getCreationHelper().createFormulaEvaluator();
        }
        catch (IOException e) {
            throw new RuntimeException("Error opening workbook", e);
        }
    }

    protected void doClose() throws Exception {
        this.workbook.close();
        if (this.workbookStream != null) {
            this.workbookStream.close();
        }
        this.workbook = null;
        this.workbookStream = null;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"'resource' not set");
        Assert.notNull(this.rowMapper, (String)"'rowMapper' not set");
    }

    @Override
    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    @Override
    public void setSheetsToRead(Set<Integer> sheetsToRead) {
        this.sheetsToRead = sheetsToRead;
    }

    @Override
    public void setRowMapper(ExcelRowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    private T readNextRow() throws Exception {
        ++this.rowNumber;
        Row row = this.rowIterator.next();
        if (this.rowNumber <= this.linesToSkip) {
            return this.doRead();
        }
        List<String> values = this.getValues(row);
        return this.rowMapper.mapRow(values, this.rowNumber);
    }

    private T readNextSheet() throws Exception {
        boolean canRead;
        ++this.sheetIndex;
        this.rowNumber = 0;
        boolean shouldRead = this.sheetsToRead == null || this.sheetsToRead.contains(this.sheetIndex);
        boolean bl = canRead = this.sheetIndex < this.workbook.getNumberOfSheets();
        if (shouldRead && canRead) {
            this.sheet = this.workbook.getSheetAt(this.sheetIndex);
            this.rowIterator = this.sheet.rowIterator();
            this.log.debug((Object)("Processing sheet " + this.sheet.getSheetName() + " at index " + this.sheetIndex));
            return this.doRead();
        }
        if (canRead) {
            this.log.debug((Object)("Skipping sheet at index " + this.sheetIndex));
            return this.readNextSheet();
        }
        this.log.debug((Object)"No more sheets to process");
        return null;
    }

    private List<String> getValues(Row row) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int i = 0; i < row.getLastCellNum(); ++i) {
            Cell cell = row.getCell(i);
            values.add(this.getValue(cell));
        }
        return values.stream().map(obj -> this.format(obj)).collect(Collectors.toList());
    }

    private Object getValue(Cell cell) {
        if (cell.getCellType() == CellType.NUMERIC && DateUtil.isCellDateFormatted((Cell)cell)) {
            return cell.getDateCellValue();
        }
        if (cell.getCellType() == CellType.NUMERIC) {
            return cell.getNumericCellValue();
        }
        if (cell.getCellType() == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cell.getCellType() == CellType.FORMULA) {
            return this.getFormulaValue(cell);
        }
        if (cell.getCellType() == CellType.BLANK) {
            return "";
        }
        return cell.getStringCellValue();
    }

    private Object getFormulaValue(Cell cell) {
        CellValue v = this.formulaEvaluator.evaluate(cell);
        if (v.getCellType() == CellType.NUMERIC) {
            return v.getNumberValue();
        }
        if (v.getCellType() == CellType.BOOLEAN) {
            return v.getBooleanValue();
        }
        return v.getStringValue();
    }

    private String format(Object object) {
        if (object instanceof Date) {
            Date date = (Date)object;
            LocalDateTime dt = new Timestamp(date.getTime()).toLocalDateTime();
            return DateTimeFormatter.BASIC_ISO_DATE.format(dt);
        }
        return object.toString();
    }
}

