/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.excel.reader;

import com.github.sourcegroove.batch.item.file.excel.reader.ExcelItemReader;
import com.github.sourcegroove.batch.item.file.excel.reader.ExcelRowMapper;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ooxml.util.SAXHelper;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.ReadOnlySharedStringsTable;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.model.SharedStrings;
import org.apache.poi.xssf.model.Styles;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class StreamingExcelItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T>
implements ExcelItemReader<T> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Resource resource;
    protected XSSFReader.SheetIterator sheetIterator;
    private Iterator<List<String>> rowIterator;
    private ExcelRowMapper<T> rowMapper;
    private int linesToSkip = 0;
    private Set<Integer> sheetsToRead;
    private int sheetIndex = -1;
    private int rowNumber = -1;
    private ReadOnlySharedStringsTable strings;
    private Styles styles;
    private DateTimeFormatter dateFormatter = DateTimeFormatter.BASIC_ISO_DATE;

    public StreamingExcelItemReader() {
        this.setName(ClassUtils.getShortName(this.getClass()));
    }

    protected T doRead() throws Exception {
        if (this.rowIterator != null && this.rowIterator.hasNext()) {
            ++this.rowNumber;
            this.log.debug((Object)("Processing row " + this.rowNumber));
            List<String> row = this.rowIterator.next();
            return this.rowNumber <= this.linesToSkip ? this.doRead() : this.rowMapper.mapRow(row, this.rowNumber);
        }
        return this.nextSheet();
    }

    protected void doOpen() throws Exception {
        this.log.info((Object)"doOpen was just called");
        Assert.isTrue((boolean)this.resource.exists(), (String)"resource does not exist");
        Assert.isTrue((boolean)this.resource.isReadable(), (String)"resource is not readable");
        try {
            OPCPackage pkg = OPCPackage.open((InputStream)this.resource.getInputStream());
            XSSFReader xssfReader = new XSSFReader(pkg);
            this.strings = new ReadOnlySharedStringsTable(pkg);
            this.styles = xssfReader.getStylesTable();
            this.sheetIterator = (XSSFReader.SheetIterator)xssfReader.getSheetsData();
            this.log.debug((Object)("Loaded file " + this.resource.getFilename()));
        }
        catch (Throwable e) {
            throw new RuntimeException("Error opening workbook", e);
        }
    }

    protected void doClose() throws Exception {
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.resource, (String)"'resource' not set");
        Assert.notNull(this.rowMapper, (String)"'rowMapper' not set");
    }

    @Override
    public void setLinesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
    }

    @Override
    public void setSheetsToRead(Set<Integer> sheetsToRead) {
        this.sheetsToRead = sheetsToRead;
    }

    @Override
    public void setRowMapper(ExcelRowMapper<T> rowMapper) {
        this.rowMapper = rowMapper;
    }

    private T nextSheet() throws Exception {
        this.log.debug((Object)"Getting next sheet");
        ++this.sheetIndex;
        this.rowNumber = 0;
        boolean shouldRead = this.sheetsToRead == null || this.sheetsToRead.contains(this.sheetIndex);
        boolean canRead = this.sheetIterator.hasNext();
        if (shouldRead && canRead) {
            this.log.debug((Object)("Processing sheet " + this.sheetIndex));
            this.rowIterator = this.getNextSheet();
            return this.doRead();
        }
        if (canRead) {
            this.log.debug((Object)("Skipping sheet at index " + this.sheetIndex));
            this.sheetIterator.next();
            return this.nextSheet();
        }
        this.log.debug((Object)"No more sheets to process");
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    protected Iterator<List<String>> getNextSheet() {
        try {
            Throwable throwable = null;
            try (InputStream stream = this.sheetIterator.next();){
                ExcelDataFormatter formatter = new ExcelDataFormatter();
                StreamingSheetContentsHandler sheetHandler = new StreamingSheetContentsHandler();
                XSSFSheetXMLHandler handler = new XSSFSheetXMLHandler(this.styles, (SharedStrings)this.strings, (XSSFSheetXMLHandler.SheetContentsHandler)sheetHandler, (DataFormatter)formatter, false);
                try {
                    XMLReader sheetParser = SAXHelper.newXMLReader();
                    sheetParser.setContentHandler((ContentHandler)handler);
                    sheetParser.parse(new InputSource(stream));
                    Iterator<List<String>> iterator = sheetHandler.getRowIterator();
                    return iterator;
                }
                catch (IOException | ParserConfigurationException | SAXException e) {
                    try {
                        throw new RuntimeException("Error processing sheet", e);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading sheet", e);
        }
    }

    private class ExcelDataFormatter
    extends DataFormatter {
        private ExcelDataFormatter() {
        }

        public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
            if (DateUtil.isADateFormat((int)formatIndex, (String)formatString) && DateUtil.isValidExcelDate((double)value)) {
                Date date = DateUtil.getJavaDate((double)value, (boolean)use1904Windowing);
                LocalDateTime dt = new Timestamp(date.getTime()).toLocalDateTime();
                return StreamingExcelItemReader.this.dateFormatter.format(dt);
            }
            return String.valueOf(value);
        }
    }

    public class StreamingSheetContentsHandler
    implements XSSFSheetXMLHandler.SheetContentsHandler {
        private Map<Integer, List<String>> rows = new HashMap<Integer, List<String>>();
        private int currentRow = 0;
        private int currentColumn = 0;

        public Iterator<List<String>> getRowIterator() {
            return this.rows.values().iterator();
        }

        public void startRow(int rowNum) {
            this.currentRow = rowNum;
        }

        public void endRow(int rowNum) {
            this.currentColumn = 0;
        }

        public void cell(String cellReference, String formattedValue, XSSFComment comment) {
            List<String> columns = this.rows.get(this.currentRow);
            if (columns == null) {
                columns = new ArrayList<String>();
            }
            if (cellReference == null) {
                cellReference = new CellAddress(this.currentRow, this.currentColumn).formatAsString();
            }
            short thisCol = new CellReference(cellReference).getCol();
            int missingColumns = thisCol - this.currentColumn - 1;
            for (int i = 0; i < missingColumns; ++i) {
                columns.add("");
            }
            this.currentColumn = thisCol;
            columns.add(formattedValue);
            this.rows.put(this.currentRow, columns);
        }
    }
}

