/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.fixed;

import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.item.file.transform.Range;

public class FixedWidthFormatBuilder {
    private static final Format DEFAULT_FORMAT = Format.STRING;
    private int length = 0;
    private StringBuilder format = new StringBuilder();

    public FixedWidthFormatBuilder append(int start, int end) {
        return this.append(start, end, DEFAULT_FORMAT);
    }

    public FixedWidthFormatBuilder append(int start, int end, Format format) {
        return this.append(new Range(start, end), format);
    }

    public FixedWidthFormatBuilder append(Range range) {
        return this.append(range, DEFAULT_FORMAT);
    }

    public FixedWidthFormatBuilder append(Range range, Format format) {
        int gap = range.getMin() - 1 - this.length;
        if (gap > 0) {
            this.append(gap, Format.CONSTANT);
        }
        int width = range.getMax() - range.getMin() + 1;
        return this.append(width, format);
    }

    public FixedWidthFormatBuilder append(int width) {
        return this.append(width, DEFAULT_FORMAT);
    }

    public FixedWidthFormatBuilder append(int width, Format format) {
        this.length += width;
        this.format.append(this.getFormat(format, width));
        return this;
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        return this.format.toString();
    }

    private String getFormat(Format type, int width) {
        String fmt = null;
        if (type == Format.CONSTANT) {
            fmt = StringUtils.rightPad((String)" ", (int)width);
        } else if (type == Format.DECIMAL) {
            fmt = "%0" + width + ".2f";
        } else if (type == Format.INTEGER) {
            fmt = "%0" + width + "d";
        } else if (type == Format.ZD) {
            fmt = "%-" + width + "." + width + "s";
        } else if (type == Format.YYYYMMDD) {
            fmt = "%tY%<tm%<td";
        } else if (type == Format.YYYYMM) {
            fmt = "%tY%<tm";
        } else if (type == Format.MMYYYY) {
            fmt = "%tm%<tY";
        } else if (type == Format.YYYY) {
            fmt = "%tY";
        } else {
            String flags = "-";
            fmt = "%" + flags + width + "." + width + "s";
        }
        return fmt;
    }

    public static enum Format {
        STRING,
        INTEGER,
        ZD,
        DECIMAL,
        YYYYMMDD,
        YYYYMM,
        YYYY,
        MMYYYY,
        CONSTANT;

    }
}

