/*
 * Decompiled with CFR 0.152.
 */
package com.github.sourcegroove.batch.item.file.fixed;

import com.github.sourcegroove.batch.item.file.Layout;
import com.github.sourcegroove.batch.item.file.fixed.FixedWidthRecordLayout;
import com.github.sourcegroove.batch.item.file.fixed.reader.FixedWidthFileItemReader;
import com.github.sourcegroove.batch.item.file.fixed.writer.FixedWidthFileFieldExtractor;
import com.github.sourcegroove.batch.item.file.fixed.writer.FixedWidthFileItemWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.batch.item.file.LineMapper;
import org.springframework.batch.item.file.mapping.BeanWrapperFieldSetMapper;
import org.springframework.batch.item.file.mapping.PatternMatchingCompositeLineMapper;
import org.springframework.batch.item.file.transform.BeanWrapperFieldExtractor;
import org.springframework.batch.item.file.transform.FixedLengthTokenizer;
import org.springframework.batch.item.file.transform.FormatterLineAggregator;
import org.springframework.batch.item.file.transform.LineAggregator;

public class FixedWidthLayout
implements Layout {
    private int linesToSkip = 0;
    private List<FixedWidthRecordLayout> records = new ArrayList<FixedWidthRecordLayout>();

    public FixedWidthLayout linesToSkip(int linesToSkip) {
        this.linesToSkip = linesToSkip;
        return this;
    }

    public FixedWidthRecordLayout record(Class targetType) {
        this.records.add(new FixedWidthRecordLayout(targetType, this));
        return this.records.get(this.records.size() - 1);
    }

    public FixedWidthFileItemWriter getItemWriter() {
        HashMap<Class, LineAggregator> lineAggregators = new HashMap<Class, LineAggregator>();
        for (FixedWidthRecordLayout recordLayout : this.records) {
            BeanWrapperFieldExtractor extractor = new BeanWrapperFieldExtractor();
            extractor.setNames(recordLayout.getColumns());
            FixedWidthFileFieldExtractor fieldExtractor = new FixedWidthFileFieldExtractor();
            fieldExtractor.setFieldExtractor(extractor);
            fieldExtractor.setCustomEditors(recordLayout.getEditors());
            FormatterLineAggregator aggregator = new FormatterLineAggregator();
            aggregator.setFieldExtractor(fieldExtractor);
            aggregator.setFormat(recordLayout.getFormat());
            lineAggregators.put(recordLayout.getTargetType(), (LineAggregator)aggregator);
        }
        FixedWidthFileItemWriter writer = new FixedWidthFileItemWriter();
        writer.setLineAggregators(lineAggregators);
        return writer;
    }

    public FixedWidthFileItemReader getItemReader() {
        HashMap<String, BeanWrapperFieldSetMapper> mappers = new HashMap<String, BeanWrapperFieldSetMapper>();
        HashMap<String, FixedLengthTokenizer> tokenizers = new HashMap<String, FixedLengthTokenizer>();
        for (FixedWidthRecordLayout recordLayout : this.records) {
            BeanWrapperFieldSetMapper fieldSetMapper = new BeanWrapperFieldSetMapper();
            fieldSetMapper.setTargetType(recordLayout.getTargetType());
            fieldSetMapper.setCustomEditors(recordLayout.getEditors());
            FixedLengthTokenizer tokenizer = new FixedLengthTokenizer();
            tokenizer.setNames(recordLayout.getColumns());
            tokenizer.setColumns(recordLayout.getColumnRanges());
            mappers.put(recordLayout.getPrefix(), fieldSetMapper);
            tokenizers.put(recordLayout.getPrefix(), tokenizer);
        }
        PatternMatchingCompositeLineMapper lineMapper = new PatternMatchingCompositeLineMapper();
        lineMapper.setFieldSetMappers(mappers);
        lineMapper.setTokenizers(tokenizers);
        FixedWidthFileItemReader reader = new FixedWidthFileItemReader();
        reader.setLineMapper((LineMapper)lineMapper);
        reader.setLinesToSkip(this.linesToSkip);
        return reader;
    }
}

