/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.distributed.dubbo.filter;

import com.github.sparkzxl.core.base.code.BaseEnumCode;
import com.github.sparkzxl.core.base.result.ApiResponseStatus;
import com.github.sparkzxl.core.support.BizException;
import java.lang.reflect.Method;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.ReflectUtils;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.rpc.Filter;
import org.apache.dubbo.rpc.Invocation;
import org.apache.dubbo.rpc.Invoker;
import org.apache.dubbo.rpc.ListenableFilter;
import org.apache.dubbo.rpc.Result;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.RpcException;
import org.apache.dubbo.rpc.service.GenericService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"provider"})
public class DubboExceptionFilter
extends ListenableFilter {
    public DubboExceptionFilter() {
        this.listener = new ExceptionListenerX();
    }

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        return invoker.invoke(invocation);
    }

    static class ExceptionListener
    implements Filter.Listener {
        private static final Logger log = LoggerFactory.getLogger(ExceptionListener.class);

        ExceptionListener() {
        }

        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            if (appResponse.hasException() && GenericService.class != invoker.getInterface()) {
                try {
                    Throwable exception = appResponse.getException();
                    if (!(exception instanceof RuntimeException) && exception instanceof Exception) {
                        return;
                    }
                    try {
                        Class<?>[] exceptionClassses;
                        Method method = invoker.getInterface().getMethod(invocation.getMethodName(), invocation.getParameterTypes());
                        for (Class<?> exceptionClass : exceptionClassses = method.getExceptionTypes()) {
                            if (!exception.getClass().equals(exceptionClass)) continue;
                            return;
                        }
                    }
                    catch (NoSuchMethodException e) {
                        return;
                    }
                    log.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + exception.getClass().getName() + ": " + exception.getMessage(), exception);
                    String serviceFile = ReflectUtils.getCodeBase((Class)invoker.getInterface());
                    String exceptionFile = ReflectUtils.getCodeBase(exception.getClass());
                    if (serviceFile == null || exceptionFile == null || serviceFile.equals(exceptionFile)) {
                        return;
                    }
                    String className = exception.getClass().getName();
                    String java = "java.";
                    String javax = "javax.";
                    if (className.startsWith(java) || className.startsWith(javax)) {
                        return;
                    }
                    if (exception instanceof RpcException) {
                        return;
                    }
                    appResponse.setException((Throwable)new RuntimeException(StringUtils.toString((Throwable)exception)));
                }
                catch (Throwable e) {
                    log.warn("Fail to ExceptionFilter when called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
                }
            }
        }

        public void onError(Throwable e, Invoker<?> invoker, Invocation invocation) {
            log.error("Got unchecked and undeclared exception which called by " + RpcContext.getContext().getRemoteHost() + ". service: " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", exception: " + e.getClass().getName() + ": " + e.getMessage(), e);
        }
    }

    static class ExceptionListenerX
    extends ExceptionListener {
        ExceptionListenerX() {
        }

        @Override
        public void onResponse(Result appResponse, Invoker<?> invoker, Invocation invocation) {
            if (appResponse.hasException() && GenericService.class != invoker.getInterface()) {
                Throwable exception = appResponse.getException();
                if (exception instanceof BizException) {
                    return;
                }
                if (exception instanceof ConstraintViolationException) {
                    appResponse.setException((Throwable)this.handleConstraintViolationException((ConstraintViolationException)exception));
                    return;
                }
            }
            super.onResponse(appResponse, invoker, invocation);
        }

        private BizException handleConstraintViolationException(ConstraintViolationException ex) {
            StringBuilder detailMessage = new StringBuilder();
            for (ConstraintViolation constraintViolation : ex.getConstraintViolations()) {
                if (detailMessage.length() > 0) {
                    detailMessage.append(";");
                }
                detailMessage.append(constraintViolation.getMessage());
            }
            return new BizException((BaseEnumCode)ApiResponseStatus.PARAM_VALID_ERROR, null, detailMessage.toString());
        }
    }
}

