/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.repository;

import cn.hutool.core.util.IdUtil;
import com.github.sparkzxl.core.utils.MapHelper;
import com.github.sparkzxl.mongodb.entity.Entity;
import com.github.sparkzxl.mongodb.entity.SuperEntity;
import com.github.sparkzxl.mongodb.repository.IBaseRepository;
import com.github.sparkzxl.mongodb.utils.MongoDbHandleUtil;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.data.repository.support.PageableExecutionUtils;

public class BaseRepository<T extends SuperEntity>
implements IBaseRepository<T> {
    protected Class<T> entityClass;
    protected MongoTemplate mongoTemplate;

    @Autowired
    public void setMongoTemplate(MongoTemplate mongoTemplate) {
        this.mongoTemplate = mongoTemplate;
    }

    @Override
    public int insert(T entity) {
        ((Entity)entity).setBusinessId(IdUtil.objectId());
        ((Entity)entity).setCreateTime(LocalDateTime.now(ZoneId.of("Asia/Shanghai")));
        ((SuperEntity)entity).setUpdateTime(LocalDateTime.now(ZoneId.of("Asia/Shanghai")));
        SuperEntity insert = (SuperEntity)this.mongoTemplate.insert(entity);
        return ObjectUtils.isNotEmpty(insert.getId()) ? 1 : 0;
    }

    @Override
    public int insertMulti(Collection<T> entityList) {
        for (SuperEntity entity : entityList) {
            entity.setBusinessId(IdUtil.objectId());
            entity.setCreateTime(LocalDateTime.now());
            entity.setUpdateTime(LocalDateTime.now());
        }
        Collection collection = this.mongoTemplate.insert(entityList, this.getEntityClass());
        return collection.size();
    }

    @Override
    public long insertOrUpdate(T entity) {
        if (ObjectUtils.isNotEmpty(((Entity)entity).getId())) {
            return this.updateById(entity);
        }
        return this.insert(entity);
    }

    @Override
    public long removeById(Serializable id) {
        DeleteResult deleteResult = this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id)), this.getEntityClass());
        return deleteResult.getDeletedCount();
    }

    @Override
    public long removeByIds(Collection<? extends Serializable> idList) {
        DeleteResult deleteResult = this.mongoTemplate.remove(new Query((CriteriaDefinition)Criteria.where((String)"_id").in(idList)), this.getEntityClass());
        return deleteResult.getDeletedCount();
    }

    @Override
    public long remove(T entity) {
        DeleteResult deleteResult = this.mongoTemplate.remove(entity);
        return deleteResult.getDeletedCount();
    }

    @Override
    public long updateById(T entity) {
        ((SuperEntity)entity).setUpdateTime(LocalDateTime.now());
        Map<String, Object> annotationValueMap = MongoDbHandleUtil.getAndAnnotationValue(entity);
        Update update = new Update();
        MapHelper.removeNullValue(annotationValueMap);
        for (String key : annotationValueMap.keySet()) {
            update.set(key, annotationValueMap.get(key));
        }
        UpdateResult updateResult = this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is(((Entity)entity).getId())), (UpdateDefinition)update, entity.getClass());
        return updateResult.getModifiedCount();
    }

    @Override
    public long update(T entity) {
        ((SuperEntity)entity).setUpdateTime(LocalDateTime.now());
        Map<String, Object> annotationValueMap = MongoDbHandleUtil.getAndAnnotationValue(entity);
        annotationValueMap.remove("create_user");
        annotationValueMap.remove("create_time");
        Update update = new Update();
        for (String key : annotationValueMap.keySet()) {
            update.set(key, annotationValueMap.get(key));
        }
        UpdateResult updateResult = this.mongoTemplate.updateFirst(new Query((CriteriaDefinition)Criteria.where((String)"_id").is(((Entity)entity).getId())), (UpdateDefinition)update, this.getEntityClass());
        return updateResult.getModifiedCount();
    }

    @Override
    public long updateMultiById(Collection<T> entityList) {
        AtomicLong atomicLong = new AtomicLong(0L);
        for (SuperEntity t : entityList) {
            this.updateById((T)t);
            atomicLong.getAndIncrement();
        }
        return atomicLong.get();
    }

    @Override
    public T findById(Serializable id) {
        return (T)((SuperEntity)this.mongoTemplate.findById((Object)id, this.getEntityClass()));
    }

    @Override
    public T findOne(Query query) {
        return (T)((SuperEntity)this.mongoTemplate.findOne(query, this.getEntityClass()));
    }

    @Override
    public long count(Query query) {
        return this.mongoTemplate.count(query, this.getEntityClass());
    }

    @Override
    public long count() {
        return this.mongoTemplate.findAll(this.getEntityClass()).stream().count();
    }

    @Override
    public List<T> findList(Query query) {
        return this.mongoTemplate.find(query, this.getEntityClass());
    }

    @Override
    public List<T> findList() {
        return this.mongoTemplate.findAll(this.getEntityClass());
    }

    @Override
    public List<T> findBatchIds(Collection<? extends Serializable> idList) {
        return this.mongoTemplate.find(new Query((CriteriaDefinition)Criteria.where((String)"_id").in(idList)), this.getEntityClass());
    }

    @Override
    public Page<T> findPage(Query query, int pageNum, int pageSize) {
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        long count = this.mongoTemplate.count(query, this.getEntityClass());
        List list = this.mongoTemplate.find(query.with((Pageable)pageable), this.getEntityClass());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, () -> count);
    }

    @Override
    public Page<T> findPage(int pageNum, int pageSize) {
        PageRequest pageable = PageRequest.of((int)pageNum, (int)pageSize);
        Query query = new Query().with((Pageable)pageable);
        long count = this.mongoTemplate.count(query, this.getEntityClass());
        List list = this.mongoTemplate.find(query.with((Pageable)pageable), this.getEntityClass());
        return PageableExecutionUtils.getPage((List)list, (Pageable)pageable, () -> count);
    }

    @Override
    public Class<T> getEntityClass() {
        if (this.entityClass == null) {
            this.entityClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        }
        return this.entityClass;
    }
}

