/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.service;

import com.github.sparkzxl.mongodb.entity.Entity;
import com.github.sparkzxl.mongodb.repository.IBaseRepository;
import com.github.sparkzxl.mongodb.service.ISuperService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public class SuperServiceImpl<R extends IBaseRepository<T>, T extends Entity>
implements ISuperService<T> {
    @Autowired
    protected R baseRepository;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean save(T entity) {
        return this.getBaseRepository().insert(entity) != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(List<T> entityList) {
        return this.getBaseRepository().insertMulti(entityList) != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdate(T entity) {
        return this.getBaseRepository().insertOrUpdate(entity) != 0L;
    }

    @Override
    public boolean saveOrUpdateBatch(Collection<T> entityList) {
        for (Entity entity : entityList) {
            this.getBaseRepository().insertOrUpdate(entity);
        }
        return true;
    }

    @Override
    public boolean removeById(Serializable id) {
        return this.getBaseRepository().removeById(id) == 1L;
    }

    @Override
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        return !CollectionUtils.isEmpty(idList) && this.getBaseRepository().removeByIds(idList) != 0L;
    }

    @Override
    public boolean updateById(T entity) {
        return this.getBaseRepository().updateById(entity) != 0L;
    }

    @Override
    public boolean update(T entity) {
        return this.getBaseRepository().update(entity) != 0L;
    }

    @Override
    public boolean updateBatchById(Collection<T> entityList) {
        return this.getBaseRepository().updateMultiById(entityList) != 0L;
    }

    @Override
    public T getById(Serializable id) {
        return this.getBaseRepository().findById(id);
    }

    @Override
    public List<T> listByIds(Collection<? extends Serializable> idList) {
        return this.getBaseRepository().findBatchIds(idList);
    }

    @Override
    public List<T> list(Query query) {
        return this.getBaseRepository().findList(query);
    }

    @Override
    public List<T> list() {
        return this.getBaseRepository().findList();
    }

    @Override
    public long count() {
        return this.getBaseRepository().count();
    }

    @Override
    public long count(Query query) {
        return this.getBaseRepository().count(query);
    }

    @Override
    public Page<T> page(Query query, int pageNum, int pageSize) {
        return this.getBaseRepository().findPage(query, pageNum, pageSize);
    }

    @Override
    public Page<T> page(int pageNum, int pageSize) {
        return this.getBaseRepository().findPage(pageNum, pageSize);
    }

    @Override
    public IBaseRepository<T> getBaseRepository() {
        return this.baseRepository;
    }
}

