/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import cn.hutool.core.text.StrFormatter;
import com.github.sparkzxl.mongodb.dynamic.DynamicMongoProperties;
import com.github.sparkzxl.mongodb.dynamic.MongoDatabaseFactoryCreator;
import com.mongodb.ConnectionString;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;

public class DefaultMongoDatabaseFactoryCreator
implements MongoDatabaseFactoryCreator {
    private static final Logger log = LoggerFactory.getLogger(DefaultMongoDatabaseFactoryCreator.class);

    @Override
    public MongoDatabaseFactory createMongoDatabaseFactory(DynamicMongoProperties.MongoDatabaseProperty mongoDatabaseProperty) {
        ConnectionString connectionString;
        if (StringUtils.isNotBlank((CharSequence)mongoDatabaseProperty.getUri())) {
            connectionString = new ConnectionString(mongoDatabaseProperty.getUri());
        } else {
            String uriTemplate = "mongodb://{}:{}@{}:{}/{}";
            String uri = StrFormatter.format((String)uriTemplate, (Object[])new Object[]{mongoDatabaseProperty.getUsername(), mongoDatabaseProperty.getPassword(), mongoDatabaseProperty.getHost(), mongoDatabaseProperty.getPort(), StringUtils.isBlank((CharSequence)mongoDatabaseProperty.getDatabase()) ? mongoDatabaseProperty.getGridFsDatabase() : mongoDatabaseProperty.getDatabase()});
            connectionString = new ConnectionString(uri);
        }
        return new SimpleMongoClientDatabaseFactory(connectionString);
    }
}

