/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import com.alibaba.ttl.TransmittableThreadLocal;
import java.util.ArrayDeque;
import java.util.Deque;
import org.springframework.util.StringUtils;

public final class DynamicDatabaseContextHolder {
    private static final ThreadLocal<Deque<String>> LOOKUP_KEY_HOLDER = new TransmittableThreadLocal(true);

    private DynamicDatabaseContextHolder() {
    }

    public static String peek() {
        return LOOKUP_KEY_HOLDER.get().peek();
    }

    public static String push(String ds) {
        String dataSourceStr = StringUtils.isEmpty((Object)ds) ? "" : ds;
        LOOKUP_KEY_HOLDER.get().push(dataSourceStr);
        return dataSourceStr;
    }

    public static void poll() {
        Deque<String> deque = LOOKUP_KEY_HOLDER.get();
        deque.poll();
        if (deque.isEmpty()) {
            LOOKUP_KEY_HOLDER.remove();
        }
    }

    public static void clear() {
        LOOKUP_KEY_HOLDER.remove();
    }

    static {
        LOOKUP_KEY_HOLDER.set(new ArrayDeque());
    }
}

