/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import com.github.sparkzxl.mongodb.dynamic.MongoDatabaseFactoryContext;
import com.mongodb.client.MongoDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

public class DynamicMongoTemplate
extends MongoTemplate {
    private static final Logger log = LoggerFactory.getLogger(DynamicMongoTemplate.class);
    private final MongoDatabaseFactoryContext mongoDatabaseFactoryContext;

    public DynamicMongoTemplate(MongoDatabaseFactory mongoDbFactory, MongoDatabaseFactoryContext mongoDatabaseFactoryContext, boolean removeClass) {
        super(mongoDbFactory);
        this.mongoDatabaseFactoryContext = mongoDatabaseFactoryContext;
        MongoConverter converter = this.getConverter();
        if (removeClass) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
    }

    protected MongoDatabase doGetDatabase() {
        MongoDatabaseFactory databaseFactory = this.mongoDatabaseFactoryContext.determineMongoDatabaseFactory();
        return databaseFactory == null ? super.doGetDatabase() : databaseFactory.getMongoDatabase();
    }
}

