/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import com.github.sparkzxl.mongodb.dynamic.MongoDatabaseFactoryContext;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.data.mongodb.MongoTransactionManager;

public class DynamicMongoTransactionManager
extends MongoTransactionManager {
    private static final Logger log = LoggerFactory.getLogger(DynamicMongoTransactionManager.class);
    private final MongoDatabaseFactoryContext mongoDatabaseFactoryContext;

    public DynamicMongoTransactionManager(MongoDatabaseFactory dbFactory, MongoDatabaseFactoryContext mongoDatabaseFactoryContext) {
        super(dbFactory);
        this.mongoDatabaseFactoryContext = mongoDatabaseFactoryContext;
    }

    public MongoDatabaseFactory getDbFactory() {
        MongoDatabaseFactory databaseFactory = this.mongoDatabaseFactoryContext.determineMongoDatabaseFactory();
        if (ObjectUtils.isEmpty((Object)databaseFactory)) {
            return super.getDbFactory();
        }
        return databaseFactory;
    }

    public MongoDatabaseFactory getResourceFactory() {
        MongoDatabaseFactory databaseFactory = this.mongoDatabaseFactoryContext.determineMongoDatabaseFactory();
        if (ObjectUtils.isEmpty((Object)databaseFactory)) {
            return super.getResourceFactory();
        }
        return databaseFactory;
    }
}

