/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import com.github.sparkzxl.mongodb.dynamic.DynamicDatabaseContextHolder;
import com.github.sparkzxl.mongodb.dynamic.DynamicMongoDatabaseFactoryProvider;
import com.mongodb.MongoException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.mongodb.MongoDatabaseFactory;
import org.springframework.util.StringUtils;

public class MongoDatabaseFactoryContext
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(MongoDatabaseFactoryContext.class);
    private String primary = "master";
    private final Map<String, MongoDatabaseFactory> databaseFactories = new ConcurrentHashMap<String, MongoDatabaseFactory>();
    private final DynamicMongoDatabaseFactoryProvider mongoDataSourceProvider;

    public MongoDatabaseFactoryContext(DynamicMongoDatabaseFactoryProvider mongoDataSourceProvider) {
        this.mongoDataSourceProvider = mongoDataSourceProvider;
    }

    public synchronized void addDatabaseFactory(String ds, MongoDatabaseFactory databaseFactory) {
        this.databaseFactories.put(ds, databaseFactory);
        log.info("dynamic-database-factory - add a database-factory named [{}] success", (Object)ds);
    }

    public synchronized void removeDataSource(String ds) {
        if (!StringUtils.hasText((String)ds)) {
            throw new RuntimeException("remove parameter could not be empty");
        }
        if (this.primary.equals(ds)) {
            throw new RuntimeException("could not remove primary database-factory");
        }
        if (this.databaseFactories.containsKey(ds)) {
            this.databaseFactories.remove(ds);
            log.info("dynamic-database-factory - remove the database named [{}] success", (Object)ds);
        } else {
            log.warn("dynamic-database-factory - could not find a database named [{}]", (Object)ds);
        }
    }

    public MongoDatabaseFactory determineMongoDatabaseFactory() {
        String dsKey = DynamicDatabaseContextHolder.peek();
        return this.getDatabaseFactory(dsKey);
    }

    public MongoDatabaseFactory getDatabaseFactory(String ds) {
        if (StringUtils.isEmpty((Object)ds)) {
            return this.determinePrimaryMongoDatabaseFactory();
        }
        if (this.databaseFactories.containsKey(ds)) {
            log.debug("dynamic-database-factory switch to the database-factory named [{}]", (Object)ds);
            return this.databaseFactories.get(ds);
        }
        return this.determinePrimaryMongoDatabaseFactory();
    }

    public MongoDatabaseFactory determinePrimaryMongoDatabaseFactory() {
        log.debug("dynamic-database-factory switch to the primary database-factory");
        MongoDatabaseFactory databaseFactory = this.databaseFactories.get(this.primary);
        if (databaseFactory != null) {
            return databaseFactory;
        }
        throw new MongoException("dynamic-database-factory can not find primary database-factory");
    }

    public void destroy() {
        log.info("dynamic-database-factory start closing ....");
        this.databaseFactories.clear();
        log.info("dynamic-database-factory all closed success,bye");
    }

    public void afterPropertiesSet() {
        Map<String, MongoDatabaseFactory> databaseFactories = this.mongoDataSourceProvider.loadMongoDatabaseFactories();
        for (Map.Entry<String, MongoDatabaseFactory> mongoDatabaseFactoryEntry : databaseFactories.entrySet()) {
            this.addDatabaseFactory(mongoDatabaseFactoryEntry.getKey(), mongoDatabaseFactoryEntry.getValue());
        }
        MongoDatabaseFactory mongoDatabaseFactory = databaseFactories.get(this.primary);
        if (ObjectUtils.isEmpty((Object)mongoDatabaseFactory)) {
            throw new MongoException("\u9ed8\u8ba4\u6570\u636e\u6e90\u5de5\u5382\u672a\u914d\u7f6e");
        }
    }

    public void setPrimary(String primary) {
        this.primary = primary;
    }
}

