/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.dynamic;

import com.github.sparkzxl.mongodb.dynamic.DynamicMongoDatabaseFactoryProvider;
import com.github.sparkzxl.mongodb.dynamic.DynamicMongoProperties;
import com.github.sparkzxl.mongodb.dynamic.DynamicMongoTemplate;
import com.github.sparkzxl.mongodb.dynamic.DynamicMongoTransactionManager;
import com.github.sparkzxl.mongodb.dynamic.MongoDatabaseFactoryContext;
import com.github.sparkzxl.mongodb.dynamic.YamlMongoDatabaseFactoryProvider;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={DynamicMongoProperties.class})
@ConditionalOnProperty(prefix="spring.dynamic.mongodb", name={"enabled"}, havingValue="true")
public class MongoDynamicAutoConfig {
    private static final Logger log = LoggerFactory.getLogger(MongoDynamicAutoConfig.class);
    private final DynamicMongoProperties dynamicMongoProperties;

    public MongoDynamicAutoConfig(DynamicMongoProperties dynamicMongoProperties) {
        this.dynamicMongoProperties = dynamicMongoProperties;
        log.info("Mongodb\u52a8\u6001\u6570\u636e\u6e90\u6b63\u5728\u52a0\u8f7d");
    }

    @Bean
    @ConditionalOnMissingBean
    public DynamicMongoDatabaseFactoryProvider dynamicMongoDatabaseFactoryProvider() {
        Map<String, DynamicMongoProperties.MongoDatabaseProperty> databasePropertyMap = this.dynamicMongoProperties.getProvider();
        return new YamlMongoDatabaseFactoryProvider(databasePropertyMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoDatabaseFactoryContext mongoDatabaseFactoryContext(DynamicMongoDatabaseFactoryProvider dynamicMongoDatabaseFactoryProvider) {
        String primary = this.dynamicMongoProperties.getPrimary();
        MongoDatabaseFactoryContext mongoDatabaseFactoryContext = new MongoDatabaseFactoryContext(dynamicMongoDatabaseFactoryProvider);
        mongoDatabaseFactoryContext.setPrimary(primary);
        return mongoDatabaseFactoryContext;
    }

    @Bean
    @ConditionalOnMissingBean
    public MongoTemplate mongoTemplate(MongoDatabaseFactoryContext mongoDatabaseFactoryContext) {
        return new DynamicMongoTemplate(mongoDatabaseFactoryContext.determinePrimaryMongoDatabaseFactory(), mongoDatabaseFactoryContext, this.dynamicMongoProperties.isRemoveClass());
    }

    @Bean
    public PlatformTransactionManager mongoTransactionManager(MongoDatabaseFactoryContext mongoDatabaseFactoryContext) {
        return new DynamicMongoTransactionManager(mongoDatabaseFactoryContext.determinePrimaryMongoDatabaseFactory(), mongoDatabaseFactoryContext);
    }
}

