/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.mongodb.event;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import com.github.sparkzxl.core.context.AppContextHolder;
import com.github.sparkzxl.mongodb.entity.Entity;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;

public class MongoInsertEventListener
extends AbstractMongoEventListener<Entity> {
    private final Snowflake snowflake = IdUtil.getSnowflake((long)0L, (long)10L);

    public void onBeforeConvert(BeforeConvertEvent<Entity> event) {
        Entity entity = (Entity)event.getSource();
        LocalDateTime dateTime = LocalDateTime.now(ZoneOffset.of("+8"));
        if (entity.getId() == null) {
            Long id = this.snowflake.nextId();
            entity.setId(id);
            entity.setCreateTime(dateTime);
            entity.setCreateUser((String)AppContextHolder.getUserId(String.class));
            entity.setCreateUserName(AppContextHolder.getName());
            entity.setUpdateTime(dateTime);
            entity.setUpdateUser((String)AppContextHolder.getUserId(String.class));
            entity.setUpdateUserName(AppContextHolder.getName());
        } else {
            entity.setUpdateTime(dateTime);
            entity.setUpdateUser((String)AppContextHolder.getUserId(String.class));
            entity.setUpdateUserName(AppContextHolder.getName());
        }
    }
}

