/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database;

import com.github.sparkzxl.database.echo.aspect.EchoResultAspect;
import com.github.sparkzxl.database.echo.core.EchoService;
import com.github.sparkzxl.database.echo.core.LoadService;
import com.github.sparkzxl.database.echo.properties.EchoProperties;
import com.github.sparkzxl.database.echo.typehandler.RemoteDataTypeHandler;
import java.util.Map;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={EchoProperties.class})
public class EchoAutoConfiguration {
    private final EchoProperties remoteProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="echo", name={"aop-enabled"}, havingValue="true", matchIfMissing=true)
    public EchoResultAspect getEchoResultAspect(EchoService echoService) {
        return new EchoResultAspect(echoService);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="echo", name={"enabled"}, havingValue="true", matchIfMissing=true)
    public EchoService echoService(Map<String, LoadService> strategyMap) {
        return new EchoService(this.remoteProperties, strategyMap);
    }

    @Bean
    @ConditionalOnMissingBean
    public RemoteDataTypeHandler getRemoteDataTypeHandler() {
        return new RemoteDataTypeHandler();
    }

    public EchoAutoConfiguration(EchoProperties remoteProperties) {
        this.remoteProperties = remoteProperties;
    }
}

