/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baidu.fsg.uid.buffer.RejectedPutBufferHandler;
import com.baidu.fsg.uid.buffer.RejectedTakeBufferHandler;
import com.baidu.fsg.uid.impl.CachedUidGenerator;
import com.baidu.fsg.uid.impl.DefaultUidGenerator;
import com.baidu.fsg.uid.impl.HuToolUidGenerator;
import com.baidu.fsg.uid.worker.DisposableWorkerIdAssigner;
import com.baidu.fsg.uid.worker.WorkerIdAssigner;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.IllegalSQLInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import com.github.sparkzxl.constant.enums.MultiTenantType;
import com.github.sparkzxl.database.mybatis.hander.MetaDataHandler;
import com.github.sparkzxl.database.mybatis.injector.BaseSqlInjector;
import com.github.sparkzxl.database.plugins.SchemaInterceptor;
import com.github.sparkzxl.database.plugins.SlowSqlMonitorInterceptor;
import com.github.sparkzxl.database.plugins.TenantLineHandlerInterceptor;
import com.github.sparkzxl.database.properties.CustomMybatisProperties;
import com.github.sparkzxl.database.properties.DataProperties;
import com.github.sparkzxl.database.support.DataBaseExceptionHandler;
import com.google.common.collect.Lists;
import com.p6spy.engine.spy.P6DataSource;
import java.util.ArrayList;
import java.util.Arrays;
import javax.sql.DataSource;
import org.apache.commons.lang3.ArrayUtils;
import org.mybatis.spring.annotation.MapperScan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Configuration
@EnableConfigurationProperties(value={CustomMybatisProperties.class, DataProperties.class})
@Import(value={DataBaseExceptionHandler.class})
@MapperScan(basePackages={"${mybatis-plus.custom.mapper-scan}"})
public class MyBatisAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MyBatisAutoConfiguration.class);
    public static final String DATABASE_PREFIX = "default";
    private final CustomMybatisProperties customMybatisProperties;
    private final DataProperties dataProperties;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sparkzxl.data", name={"id-type"}, havingValue="DEFAULT")
    public UidGenerator getDefaultUidGenerator(DisposableWorkerIdAssigner disposableWorkerIdAssigner) {
        DefaultUidGenerator uidGenerator = new DefaultUidGenerator();
        BeanUtil.copyProperties((Object)this.dataProperties.getDefaultId(), (Object)uidGenerator, (String[])new String[0]);
        uidGenerator.setWorkerIdAssigner((WorkerIdAssigner)disposableWorkerIdAssigner);
        return uidGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sparkzxl.data", name={"id-type"}, havingValue="CACHE")
    public UidGenerator getCacheUidGenerator(DisposableWorkerIdAssigner disposableWorkerIdAssigner) {
        CachedUidGenerator uidGenerator = new CachedUidGenerator();
        DataProperties.CacheId cacheId = this.dataProperties.getCacheId();
        BeanUtil.copyProperties((Object)cacheId, (Object)uidGenerator, (String[])new String[0]);
        if (cacheId.getRejectedPutBufferHandlerClass() != null) {
            RejectedPutBufferHandler rejectedPutBufferHandler = (RejectedPutBufferHandler)ReflectUtil.newInstance(cacheId.getRejectedPutBufferHandlerClass(), (Object[])new Object[0]);
            uidGenerator.setRejectedPutBufferHandler(rejectedPutBufferHandler);
        }
        if (cacheId.getRejectedTakeBufferHandlerClass() != null) {
            RejectedTakeBufferHandler rejectedTakeBufferHandler = (RejectedTakeBufferHandler)ReflectUtil.newInstance(cacheId.getRejectedTakeBufferHandlerClass(), (Object[])new Object[0]);
            uidGenerator.setRejectedTakeBufferHandler(rejectedTakeBufferHandler);
        }
        uidGenerator.setWorkerIdAssigner((WorkerIdAssigner)disposableWorkerIdAssigner);
        return uidGenerator;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="sparkzxl.data", name={"id-type"}, havingValue="HU_TOOL", matchIfMissing=true)
    public UidGenerator getHuToolUidGenerator() {
        DataProperties.HutoolId id = this.dataProperties.getHutoolId();
        return new HuToolUidGenerator(id.getWorkerId().longValue(), id.getDataCenterId().longValue());
    }

    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        interceptor.addInnerInterceptor((InnerInterceptor)new OptimisticLockerInnerInterceptor());
        MultiTenantType multiTenantType = this.dataProperties.getMultiTenantType();
        if (multiTenantType.eq(MultiTenantType.COLUMN)) {
            if (this.dataProperties.isEnableTenant()) {
                ArrayList ignoreTableList = ArrayUtils.isEmpty((Object[])this.dataProperties.getIgnoreTable()) ? Lists.newArrayList() : Arrays.asList(this.dataProperties.getIgnoreTable());
                interceptor.addInnerInterceptor((InnerInterceptor)new TenantLineInnerInterceptor((TenantLineHandler)new TenantLineHandlerInterceptor(this.dataProperties.getTenantIdColumn(), ignoreTableList)));
            }
        } else if (multiTenantType.eq(MultiTenantType.SCHEMA)) {
            SchemaInterceptor schemaInterceptor = new SchemaInterceptor(this.dataProperties.getTenantDatabasePrefix());
            interceptor.addInnerInterceptor((InnerInterceptor)schemaInterceptor);
        }
        if (this.customMybatisProperties.isEnablePage()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor(this.customMybatisProperties.getDbType()));
        }
        if (this.dataProperties.getIsIllegalSql().booleanValue()) {
            interceptor.addInnerInterceptor((InnerInterceptor)new IllegalSQLInnerInterceptor());
        }
        return interceptor;
    }

    @Primary
    @Bean(name={"defaultTransactionManager"})
    public DataSourceTransactionManager dataSourceTransactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Primary
    @Bean(name={"defaultDataSource"})
    @DependsOn(value={"dataSource"})
    @ConditionalOnProperty(prefix="spring.datasource.dynamic", name={"enabled"}, havingValue="false")
    public DataSource dataSource(DataSource dataSource) {
        if (this.dataProperties.getP6spy().booleanValue()) {
            return new P6DataSource(dataSource);
        }
        return dataSource;
    }

    @Bean
    public Snowflake snowflake() {
        return IdUtil.getSnowflake((long)this.dataProperties.getWorkerId(), (long)this.dataProperties.getDataCenterId());
    }

    @Bean
    @ConditionalOnMissingBean
    public MetaObjectHandler metaDataHandler() {
        return new MetaDataHandler();
    }

    @Bean
    public BaseSqlInjector sqlInjector() {
        return new BaseSqlInjector();
    }

    @Bean
    public SlowSqlMonitorInterceptor slowSqlMonitorInterceptor(ApplicationContext applicationContext) {
        SlowSqlMonitorInterceptor slowSqlMonitorInterceptor = new SlowSqlMonitorInterceptor();
        slowSqlMonitorInterceptor.setApplicationContext(applicationContext);
        return slowSqlMonitorInterceptor;
    }

    public MyBatisAutoConfiguration(CustomMybatisProperties customMybatisProperties, DataProperties dataProperties) {
        this.customMybatisProperties = customMybatisProperties;
        this.dataProperties = dataProperties;
    }
}

