/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.aspect;

import com.github.sparkzxl.annotation.ApiIdempotent;
import com.github.sparkzxl.cache.service.GeneralCacheService;
import com.github.sparkzxl.core.base.result.ResponseInfoStatus;
import com.github.sparkzxl.core.support.ExceptionAssert;
import com.github.sparkzxl.core.util.RequestContextHolderUtils;
import com.github.sparkzxl.database.aspect.LockKeyGenerator;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ApiIdempotentAspect {
    private static final Logger log = LoggerFactory.getLogger(ApiIdempotentAspect.class);
    private final GeneralCacheService generalCacheService;
    private LockKeyGenerator lockKeyGenerator;

    public ApiIdempotentAspect(GeneralCacheService generalCacheService) {
        this.generalCacheService = generalCacheService;
    }

    @Pointcut(value="@annotation(com.github.sparkzxl.annotation.ApiIdempotent)")
    public void executeApiIdempotent() {
    }

    public void setLockKeyGenerator(LockKeyGenerator lockKeyGenerator) {
        this.lockKeyGenerator = lockKeyGenerator;
    }

    @Around(value="executeApiIdempotent()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        HttpServletRequest httpServletRequest = RequestContextHolderUtils.getRequest();
        Signature signature = joinPoint.getSignature();
        Method method = ((MethodSignature)signature).getMethod();
        ApiIdempotent apiIdempotent = method.getAnnotation(ApiIdempotent.class);
        if (StringUtils.isEmpty((CharSequence)apiIdempotent.prefix())) {
            ExceptionAssert.failure((int)ResponseInfoStatus.PARAM_VALID_ERROR.getCode(), (String)"lock key don't null...");
        }
        String message = apiIdempotent.message();
        String lockKey = this.lockKeyGenerator.getLockKey(joinPoint);
        log.info("\u63a5\u53e3[{}]\u5e42\u7b49\u6027\u6821\u9a8c\uff0ckey:[{}]", (Object)httpServletRequest.getRequestURL().toString(), (Object)lockKey);
        boolean success = this.generalCacheService.setIfAbsent(lockKey, (Object)lockKey, Long.valueOf(apiIdempotent.expireMillis()), apiIdempotent.timeUnit());
        Object result = null;
        if (success) {
            result = joinPoint.proceed();
        } else {
            log.error("Idempotent hits, key\uff1a[{}], error msg\uff1a[{}]" + lockKey, (Object)message);
            ExceptionAssert.failure((int)ResponseInfoStatus.FAILURE.getCode(), (String)message);
        }
        return result;
    }
}

