/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.aspect;

import com.github.sparkzxl.annotation.ApiIdempotent;
import com.github.sparkzxl.annotation.ApiIdempotentParam;
import com.github.sparkzxl.core.generator.CacheKeyGenerator;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.util.ReflectionUtils;

public class LockKeyGenerator
implements CacheKeyGenerator {
    public String getLockKey(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        ApiIdempotent apiIdempotent = method.getAnnotation(ApiIdempotent.class);
        Object[] args = joinPoint.getArgs();
        Parameter[] parameters = method.getParameters();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            ApiIdempotentParam annotation = parameters[i].getAnnotation(ApiIdempotentParam.class);
            if (annotation == null) continue;
            builder.append(apiIdempotent.delimiter()).append(args[i]);
        }
        if (StringUtils.isEmpty((CharSequence)builder.toString())) {
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            for (int i = 0; i < parameterAnnotations.length; ++i) {
                Field[] fields;
                Object object = args[i];
                for (Field field : fields = object.getClass().getDeclaredFields()) {
                    ApiIdempotentParam annotation = field.getAnnotation(ApiIdempotentParam.class);
                    if (annotation == null) continue;
                    field.setAccessible(true);
                    builder.append(apiIdempotent.delimiter()).append(ReflectionUtils.getField((Field)field, (Object)object));
                }
            }
        }
        return apiIdempotent.prefix() + builder;
    }
}

