/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.base.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.net.URLEncoder;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.excel.EasyExcel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageInfo;
import com.github.sparkzxl.core.support.ExceptionAssert;
import com.github.sparkzxl.core.util.DateUtils;
import com.github.sparkzxl.database.base.controller.BaseController;
import com.github.sparkzxl.database.base.listener.ImportDataListener;
import com.github.sparkzxl.database.dto.DeleteDTO;
import com.github.sparkzxl.database.dto.PageParams;
import com.github.sparkzxl.database.util.PageInfoUtils;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public interface CurdController<Entity, Id extends Serializable, SaveDTO, UpdateDTO, QueryDTO, ExcelEntity>
extends BaseController<Entity> {
    public static final Logger logger = LoggerFactory.getLogger(CurdController.class);

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping(value={"/save"})
    default public boolean save(@RequestBody @Validated SaveDTO saveDTO) {
        boolean result = this.handlerSave(saveDTO);
        if (result) {
            Object model = BeanUtil.toBean(saveDTO, this.getEntityClass());
            return this.getBaseService().save(model);
        }
        return false;
    }

    default public boolean handlerSave(SaveDTO model) {
        return true;
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PutMapping(value={"/update"})
    default public boolean update(@RequestBody @Validated UpdateDTO updateDTO) {
        boolean result = this.handlerUpdate(updateDTO);
        if (result) {
            Object model = BeanUtil.toBean(updateDTO, this.getEntityClass());
            return this.getBaseService().updateById(model);
        }
        return false;
    }

    default public boolean handlerUpdate(UpdateDTO model) {
        return true;
    }

    @ApiOperation(value="\u5220\u9664\u6570\u636e")
    @DeleteMapping(value={"/delete"})
    default public boolean delete(@RequestBody DeleteDTO<Id> deleteDTO) {
        boolean result;
        if (CollectionUtils.isEmpty(deleteDTO.getIds())) {
            ExceptionAssert.failure((String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result = this.handlerDelete(deleteDTO.getIds())) {
            return this.getBaseService().removeByIds(deleteDTO.getIds());
        }
        return false;
    }

    default public boolean handlerDelete(List<Id> ids) {
        return true;
    }

    default public PageInfo<?> handlerResult(PageInfo<Entity> pageInfo) {
        return null;
    }

    default public String getDbField(String beanField, Class<?> clazz) {
        Field field = ReflectUtil.getField(clazz, (String)beanField);
        if (field == null) {
            return "";
        }
        TableField tf = field.getAnnotation(TableField.class);
        if (tf != null && StringUtils.isNotEmpty((CharSequence)tf.value())) {
            return tf.value();
        }
        return "";
    }

    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u4e3b\u952e", dataType="long", paramType="query")})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e", notes="\u67e5\u8be2")
    @GetMapping(value={"/get"})
    default public Entity get(@RequestParam(value="id") Id id) {
        Object entity = this.getBaseService().getById((Serializable)id);
        this.handlerEntity(entity);
        return (Entity)entity;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/page"})
    default public PageInfo<?> page(@RequestBody @Validated PageParams<QueryDTO> params) {
        return this.query(params);
    }

    default public PageInfo<?> query(PageParams<QueryDTO> params) {
        this.handlerQueryParams(params);
        Object model = BeanUtil.toBean(params.getModel(), this.getEntityClass());
        QueryWrapper<Object> wrapper = this.handlerWrapper(model, params);
        params.startPage();
        List entityList = this.getBaseService().list((Wrapper)wrapper);
        PageInfo pageInfo = PageInfoUtils.pageInfo(entityList);
        PageInfo<?> pageInfoDto = this.handlerResult(pageInfo);
        if (ObjectUtils.isNotEmpty(pageInfoDto)) {
            return pageInfoDto;
        }
        return pageInfo;
    }

    default public void handlerEntity(Entity entity) {
    }

    default public void handlerQueryParams(PageParams<QueryDTO> params) {
    }

    default public QueryWrapper<Entity> handlerWrapper(Entity model, PageParams<QueryDTO> params) {
        QueryWrapper wrapper;
        QueryWrapper queryWrapper = wrapper = model == null ? new QueryWrapper() : new QueryWrapper(model);
        if (CollUtil.isNotEmpty(params.getMap())) {
            Map<String, String> map = params.getMap();
            for (Map.Entry<String, String> field : map.entrySet()) {
                String beanField;
                String key = field.getKey();
                String value = field.getValue();
                if (StrUtil.isEmpty((CharSequence)value)) continue;
                DateTime date = DateUtils.parse((CharSequence)value);
                if (key.endsWith("_st")) {
                    beanField = StrUtil.subBefore((CharSequence)key, (CharSequence)"_st", (boolean)true);
                    wrapper.ge((Object)this.getDbField(beanField, this.getEntityClass()), (Object)DateUtils.beginOfDay((Date)date));
                }
                if (!key.endsWith("_ed")) continue;
                beanField = StrUtil.subBefore((CharSequence)key, (CharSequence)"_ed", (boolean)true);
                wrapper.le((Object)this.getDbField(beanField, this.getEntityClass()), (Object)DateUtils.endOfDay((Date)date));
            }
        }
        return wrapper;
    }

    @ApiOperation(value="\u5217\u8868\u67e5\u8be2", notes="\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    default public List<Entity> query(@RequestBody QueryDTO data) {
        Object model = BeanUtil.toBean(data, this.getEntityClass());
        QueryWrapper wrapper = new QueryWrapper(model);
        return this.getBaseService().list((Wrapper)wrapper);
    }

    @ApiOperation(value="\u5bfc\u5165\u6570\u636e")
    @PostMapping(value={"/import"})
    default public Integer importData(@RequestParam(value="file") MultipartFile multipartFile) {
        ImportDataListener<?> importDataListener = this.getImportDataListener();
        try {
            Class<?> importExcelClass = this.importExcelClass();
            if (ObjectUtils.isEmpty(importExcelClass)) {
                logger.error("\u8bf7\u5148\u5b9e\u4f8b\u5316\u5bfc\u5165Excel\u5904\u7406\u7c7b\uff1a{}", importExcelClass);
            }
            importDataListener.setList(Lists.newArrayList());
            importDataListener.setCount(0);
            EasyExcel.read((InputStream)multipartFile.getInputStream(), importExcelClass, importDataListener).sheet(Integer.valueOf(0)).doRead();
            return importDataListener.getCount();
        }
        catch (IOException e) {
            e.printStackTrace();
            TransactionAspectSupport.currentTransactionStatus().setRollbackOnly();
            logger.error("\u8bfb\u53d6Excel\u53d1\u751f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            return 0;
        }
    }

    default public ImportDataListener<?> getImportDataListener() {
        return new ImportDataListener();
    }

    default public Class<?> importExcelClass() {
        return null;
    }

    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e")
    @GetMapping(value={"/export"})
    @RequestMapping(value={"/export"}, method={RequestMethod.POST}, produces={"application/octet-stream"})
    default public void exportData(@RequestBody QueryDTO queryDTO, HttpServletResponse response) throws IOException {
        List<Object> entityList = Lists.newArrayList();
        boolean result = this.handlerExcelQueryList(queryDTO, entityList);
        if (!result) {
            entityList = this.query(queryDTO);
        }
        List<ExcelEntity> excelEntities = this.convertExcels(entityList);
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String fileName = this.getFileName();
        response.setHeader("Content-disposition", "attachment;filename=" + fileName + ".xlsx");
        Class excelClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[6];
        EasyExcel.write((OutputStream)response.getOutputStream(), (Class)excelClass).sheet("\u6a21\u677f").doWrite(excelEntities);
    }

    default public boolean handlerExcelQueryList(QueryDTO queryDTO, List<Entity> entityList) {
        return false;
    }

    default public List<ExcelEntity> convertExcels(List<Entity> entityList) {
        return Lists.newArrayList();
    }

    default public String getFileName() {
        return URLEncoder.ALL.encode("data_export_".concat(String.valueOf(System.currentTimeMillis())), StandardCharsets.UTF_8);
    }
}

