/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.base.service.impl;

import cn.hutool.core.collection.CollUtil;
import com.github.sparkzxl.cache.service.GeneralCacheService;
import com.github.sparkzxl.core.util.BuildKeyUtil;
import com.github.sparkzxl.database.base.mapper.SuperMapper;
import com.github.sparkzxl.database.base.service.SuperCacheService;
import com.github.sparkzxl.database.base.service.impl.SuperServiceImpl;
import com.github.sparkzxl.entity.data.SuperEntity;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

public abstract class SuperCacheServiceImpl<M extends SuperMapper<T>, T>
extends SuperServiceImpl<M, T>
implements SuperCacheService<T> {
    protected GeneralCacheService generalCacheService;

    @Autowired
    public void setGeneralCacheService(GeneralCacheService generalCacheService) {
        this.generalCacheService = generalCacheService;
    }

    protected abstract String getRegion();

    @Override
    public T getByIdCache(Serializable id) {
        long expireTime = 1L;
        return (T)this.generalCacheService.get(BuildKeyUtil.generateKey((String)this.getRegion(), (Object[])new Object[]{id}), x -> super.getById(id), Long.valueOf(expireTime), TimeUnit.DAYS);
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeById(Serializable id) {
        boolean bool = super.removeById(id);
        this.generalCacheService.remove(new String[]{BuildKeyUtil.generateKey((String)this.getRegion(), (Object[])new Object[]{id})});
        return bool;
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollUtil.isEmpty(idList)) {
            return true;
        }
        boolean flag = super.removeByIds(idList);
        idList.forEach(id -> this.generalCacheService.remove(new String[]{BuildKeyUtil.generateKey((String)this.getRegion(), (Object[])new Object[]{id})}));
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean save(T model) {
        boolean result = super.save(model);
        if (model instanceof SuperEntity) {
            this.generalCacheService.set(BuildKeyUtil.generateKey((String)this.getRegion(), (Object[])new Object[]{((SuperEntity)model).getId()}), model);
        }
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateById(T model) {
        boolean updateBool = super.updateById(model);
        if (model instanceof SuperEntity) {
            this.generalCacheService.remove(new String[]{BuildKeyUtil.generateKey((String)this.getRegion(), (Object[])new Object[]{((SuperEntity)model).getId()})});
        }
        return updateBool;
    }
}

