/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.echo.aspect;

import com.github.sparkzxl.annotation.echo.EchoResult;
import com.github.sparkzxl.database.echo.core.EchoService;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class EchoResultAspect {
    private static final Logger log = LoggerFactory.getLogger(EchoResultAspect.class);
    private final EchoService echoService;

    @Pointcut(value="@annotation(com.github.sparkzxl.annotation.echo.EchoResult)")
    public void methodPointcut() {
    }

    @Around(value="methodPointcut()&&@annotation(echoResult)")
    public Object interceptor(ProceedingJoinPoint pjp, EchoResult echoResult) throws Throwable {
        Object proceed = pjp.proceed();
        this.echoService.action(proceed, echoResult.ignoreFields());
        return proceed;
    }

    public EchoResultAspect(EchoService echoService) {
        this.echoService = echoService;
    }
}

