/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.mybatis.hander;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.baidu.fsg.uid.UidGenerator;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.github.sparkzxl.core.context.RequestLocalContextHolder;
import com.github.sparkzxl.core.spring.SpringContextUtils;
import com.github.sparkzxl.core.util.ReflectObjectUtil;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.util.Date;
import org.apache.ibatis.reflection.MetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaDataHandler
implements MetaObjectHandler {
    private static final Logger log = LoggerFactory.getLogger(MetaDataHandler.class);
    private UidGenerator uidGenerator;

    public void insertFill(MetaObject metaObject) {
        this.insertCommonColumn(metaObject);
        this.updateCommonColumn(metaObject);
    }

    public void insertCommonColumn(MetaObject metaObject) {
        log.debug("start update fill ....");
        Object targetObject = metaObject.getOriginalObject();
        this.extractId(metaObject, targetObject, "id");
        this.extractUserId(metaObject, targetObject, "createUser");
        this.extractUserId(metaObject, targetObject, "createUserId");
        this.extractUserName(metaObject, targetObject, "createUserName");
        this.extractDate(metaObject, targetObject, "createTime");
    }

    public void updateFill(MetaObject metaObject) {
        log.debug("start update fill ....");
        this.updateCommonColumn(metaObject);
    }

    public void updateCommonColumn(MetaObject metaObject) {
        Object targetObject = metaObject.getOriginalObject();
        this.extractUserId(metaObject, targetObject, "updateUser");
        this.extractUserId(metaObject, targetObject, "updateUserId");
        this.extractUserName(metaObject, targetObject, "updateUserName");
        this.extractDate(metaObject, targetObject, "updateTime");
    }

    private void extractId(MetaObject metaObject, Object targetObject, String field) {
        boolean idExistClass = ReflectObjectUtil.existProperty((Object)targetObject, (String)field);
        if (idExistClass) {
            if (this.uidGenerator == null) {
                this.uidGenerator = (UidGenerator)SpringContextUtils.getBean(UidGenerator.class);
            }
            Long id = this.uidGenerator.getUid();
            Object idVal = ReflectObjectUtil.getValueByKey((Object)targetObject, (String)field);
            if (ObjectUtils.isEmpty((Object)idVal)) {
                idVal = String.class.getName().equals(metaObject.getGetterType(field).getTypeName()) ? String.valueOf(id) : id;
                this.setFieldValByName(field, idVal, metaObject);
            }
        } else {
            if (this.uidGenerator == null) {
                this.uidGenerator = (UidGenerator)SpringContextUtils.getBean(UidGenerator.class);
            }
            Long id = this.uidGenerator.getUid();
            TableInfo tableInfo = TableInfoHelper.getTableInfo(metaObject.getOriginalObject().getClass());
            if (tableInfo == null) {
                return;
            }
            Class keyType = tableInfo.getKeyType();
            if (keyType == null) {
                return;
            }
            String keyProperty = tableInfo.getKeyProperty();
            Object oldId = metaObject.getValue(keyProperty);
            if (oldId != null) {
                return;
            }
            Field idField = ReflectUtil.getField(metaObject.getOriginalObject().getClass(), (String)keyProperty);
            Object fieldValue = ReflectUtil.getFieldValue((Object)metaObject.getOriginalObject(), (Field)idField);
            if (ObjectUtil.isNotEmpty((Object)fieldValue)) {
                return;
            }
            Object idVal = keyType.getName().equalsIgnoreCase("java.lang.String") ? String.valueOf(id) : id;
            this.setFieldValByName(keyProperty, idVal, metaObject);
        }
    }

    private void extractUserId(MetaObject metaObject, Object targetObject, String field) {
        Object userIdVal;
        boolean userIdExistClass = ReflectObjectUtil.existProperty((Object)targetObject, (String)field);
        if (userIdExistClass && (ObjectUtils.isEmpty((Object)(userIdVal = ReflectObjectUtil.getValueByKey((Object)targetObject, (String)field))) || userIdVal.equals(0))) {
            Class userIdClass = metaObject.getGetterType(field);
            userIdVal = RequestLocalContextHolder.getUserId((Class)userIdClass);
            this.setFieldValByName(field, userIdVal, metaObject);
        }
    }

    private void extractUserName(MetaObject metaObject, Object targetObject, String field) {
        Object userNameVal;
        boolean userNameExistClass = ReflectObjectUtil.existProperty((Object)targetObject, (String)field);
        if (userNameExistClass && ObjectUtils.isEmpty((Object)(userNameVal = ReflectObjectUtil.getValueByKey((Object)targetObject, (String)field)))) {
            userNameVal = RequestLocalContextHolder.getName();
            this.setFieldValByName(field, userNameVal, metaObject);
        }
    }

    private void extractDate(MetaObject metaObject, Object targetObject, String field) {
        Object dateVal;
        boolean dateExistClass = ReflectObjectUtil.existProperty((Object)targetObject, (String)field);
        if (dateExistClass && ObjectUtils.isEmpty((Object)(dateVal = ReflectObjectUtil.getValueByKey((Object)targetObject, (String)field)))) {
            Class dateClass = metaObject.getGetterType(field);
            dateVal = Date.class.equals((Object)dateClass) ? new Date() : LocalDateTime.now();
            this.setFieldValByName(field, dateVal, metaObject);
        }
    }

    public UidGenerator getUidGenerator() {
        return this.uidGenerator;
    }

    public void setUidGenerator(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }
}

