/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.plugins;

import com.alibaba.ttl.TransmittableThreadLocal;
import com.alibaba.ttl.threadpool.TtlExecutors;
import com.github.sparkzxl.constant.enums.EnvironmentEnum;
import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.ObjectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class SlowSqlMonitorInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(SlowSqlMonitorInterceptor.class);
    private static final ExecutorService THREAD_POOL = TtlExecutors.getTtlExecutorService((ExecutorService)new ThreadPoolExecutor(5, 5, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000), new ThreadPoolExecutor.DiscardPolicy()));
    private static final TransmittableThreadLocal<String> CONTEXT = new TransmittableThreadLocal();
    private long longQueryTime = 3000L;
    private ApplicationContext applicationContext;

    private static String getParameterValue(Object obj) {
        if (obj instanceof String) {
            return "'" + obj + "'";
        }
        if (obj instanceof Date) {
            DateFormat formatter = DateFormat.getDateTimeInstance(2, 2, Locale.CHINA);
            return "'" + formatter.format(new Date()) + "'";
        }
        if (Objects.isNull(obj)) {
            return "";
        }
        return obj.toString();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @PostConstruct
    public void init() {
        String environment;
        String string = environment = StringUtils.isEmpty((CharSequence)this.applicationContext.getEnvironment().getProperty("spring.profiles.active")) ? "dev" : this.applicationContext.getEnvironment().getProperty("spring.profiles.active");
        if (StringUtils.equals((CharSequence)environment, (CharSequence)StringUtils.toRootLowerCase((String)EnvironmentEnum.GRAY.name())) || StringUtils.equals((CharSequence)environment, (CharSequence)StringUtils.toRootLowerCase((String)EnvironmentEnum.PROD.name()))) {
            return;
        }
        this.longQueryTime = 10000L;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        long executeTime;
        Object returnValue;
        Stopwatch dbStopwatch = Stopwatch.createStarted();
        try {
            returnValue = invocation.proceed();
            executeTime = dbStopwatch.elapsed(TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.doSomething(invocation, e.getCause() == null ? e.getMessage() : e.getCause().getMessage(), Type.SQL_EXCEPTION);
            throw new Throwable(e);
        }
        this.doSomething(invocation, executeTime, Type.SLOW_SQL);
        return returnValue;
    }

    private void doSomething(Invocation invocation, long executeTime, Type type) {
        this.doSomething(invocation, executeTime, null, type);
    }

    private void doSomething(Invocation invocation, String exceptionMsg, Type type) {
        this.doSomething(invocation, 0L, exceptionMsg, type);
    }

    private void doSomething(Invocation invocation, long executeTime, String exceptionMsg, Type type) {
        try {
            if (ObjectUtils.nullSafeEquals((Object)((Object)type), (Object)((Object)Type.SLOW_SQL)) && executeTime <= this.longQueryTime) {
                return;
            }
            CONTEXT.set((Object)this.getStackTrace());
            assert (THREAD_POOL != null);
            THREAD_POOL.execute(() -> {
                try {
                    Stopwatch checkTime = Stopwatch.createStarted();
                    MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
                    Object parameter = null;
                    if (invocation.getArgs().length > 1) {
                        parameter = invocation.getArgs()[1];
                    }
                    String sqlId = mappedStatement.getId();
                    BoundSql boundSql = mappedStatement.getBoundSql(parameter);
                    Configuration configuration = mappedStatement.getConfiguration();
                    String sql = this.parseSql(configuration, boundSql);
                    switch (type) {
                        case SLOW_SQL: {
                            this.checkSlowSql(sqlId, sql, executeTime, checkTime.elapsed(TimeUnit.MILLISECONDS));
                            break;
                        }
                        case SQL_EXCEPTION: {
                            this.sendSqlExceptionMsg(sqlId, sql, exceptionMsg, checkTime.elapsed(TimeUnit.MILLISECONDS));
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendSqlExceptionMsg(String sqlId, String sql, String exceptionMsg, long checkTime) {
        String sqlMsg = String.format("\u5f02\u5e38sql, \u68c0\u6d4b\u8017\u65f6\uff1a[%d]ms\nSQLId: \n\t %s\n\nSQL\u8bed\u53e5: \n\t %s \n\n\u5f02\u5e38\u4fe1\u606f: \n\t %s \n\n\u65b9\u6cd5\u8c03\u7528\u4fe1\u606f:", checkTime, sqlId, sql, exceptionMsg);
        this.sendMsg(sqlMsg);
    }

    private void checkSlowSql(String sqlId, String sql, long executeTime, long checkTime) {
        if (executeTime >= this.longQueryTime) {
            try {
                String sqlMsg = String.format("\u6162sql, \u6267\u884c\u8017\u65f6: [%d]ms\uff0c\u68c0\u6d4b\u8017\u65f6\uff1a[%d]ms\nSQLId: \n\t %s\n\nSQL\u8bed\u53e5: \n\t %s \n\n\u65b9\u6cd5\u8c03\u7528\u4fe1\u606f:", executeTime, checkTime, sqlId, sql);
                this.sendMsg(sqlMsg);
            }
            catch (Exception e) {
                log.error("\u53d1\u9001\u9489\u9489\u6d88\u606f\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private void sendMsg(String msg) {
        msg = msg + (String)CONTEXT.get();
        log.warn(msg);
    }

    private String getStackTrace() {
        Object[] elements = Thread.currentThread().getStackTrace();
        if (ArrayUtils.isEmpty((Object[])elements) || elements.length < 5) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 4; i < elements.length; ++i) {
            String className;
            Object stackTraceElement = elements[i];
            if (Objects.isNull(stackTraceElement) || Strings.isNullOrEmpty((String)(className = ((StackTraceElement)stackTraceElement).getClassName())) || !className.startsWith("com.github.sparkzxl") || className.equals(SlowSqlMonitorInterceptor.class.getName())) continue;
            sb.append("\t ").append(className).append(".").append(((StackTraceElement)stackTraceElement).getMethodName()).append("(").append(((StackTraceElement)stackTraceElement).getFileName()).append(":").append(((StackTraceElement)stackTraceElement).getLineNumber()).append(")").append("\n");
        }
        return sb.toString();
    }

    private String parseSql(Configuration configuration, BoundSql boundSql) {
        Object parameterObject = boundSql.getParameterObject();
        String anyBlankRegex = "[\\s]+";
        String sql = boundSql.getSql().replaceAll(anyBlankRegex, " ");
        if (Objects.isNull(parameterObject)) {
            return sql;
        }
        List parameterMappings = boundSql.getParameterMappings();
        if (CollectionUtils.isEmpty((Collection)parameterMappings)) {
            return sql;
        }
        TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
        if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
            sql = this.replaceFirstParameter(sql, parameterObject);
            return sql;
        }
        MetaObject metaObject = configuration.newMetaObject(parameterObject);
        for (ParameterMapping parameterMapping : parameterMappings) {
            Object obj;
            String propertyName = parameterMapping.getProperty();
            if (metaObject.hasGetter(propertyName)) {
                obj = metaObject.getValue(propertyName);
                if (Objects.isNull(obj)) continue;
                sql = this.replaceFirstParameter(sql, obj);
                continue;
            }
            if (!boundSql.hasAdditionalParameter(propertyName) || Objects.isNull(obj = boundSql.getAdditionalParameter(propertyName))) continue;
            sql = this.replaceFirstParameter(sql, obj);
        }
        return sql;
    }

    private String replaceFirstParameter(String sql, Object obj) {
        return sql.replaceFirst("\\?", Matcher.quoteReplacement(SlowSqlMonitorInterceptor.getParameterValue(obj)));
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    static enum Type {
        SLOW_SQL,
        SQL_EXCEPTION;

    }
}

