/*
 * Decompiled with CFR 0.152.
 */
package com.github.sparkzxl.database.support;

import com.github.sparkzxl.annotation.ResponseResultStatus;
import com.github.sparkzxl.constant.enums.BeanOrderEnum;
import com.github.sparkzxl.core.base.result.ResponseInfoStatus;
import com.github.sparkzxl.core.base.result.ResponseResult;
import com.github.sparkzxl.core.support.BizException;
import com.github.sparkzxl.core.support.TenantException;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import org.apache.ibatis.exceptions.PersistenceException;
import org.apache.ibatis.exceptions.TooManyResultsException;
import org.mybatis.spring.MyBatisSystemException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
@RestController
@ResponseResultStatus
public class DataBaseExceptionHandler
implements Ordered {
    private static final Logger log = LoggerFactory.getLogger(DataBaseExceptionHandler.class);

    @ExceptionHandler(value={SQLSyntaxErrorException.class})
    public ResponseResult<?> handleSqlSyntaxErrorException(SQLSyntaxErrorException e) {
        log.error("SQL\u5f02\u5e38\uff1a", (Throwable)e);
        return ResponseResult.result((ResponseInfoStatus)ResponseInfoStatus.SQL_EX);
    }

    @ExceptionHandler(value={TooManyResultsException.class})
    public ResponseResult<?> handleTooManyResultsException(TooManyResultsException e) {
        log.error("\u67e5\u8be2\u5f02\u5e38\uff1a", (Throwable)e);
        return ResponseResult.result((ResponseInfoStatus)ResponseInfoStatus.SQL_MANY_RESULT_EX);
    }

    @ExceptionHandler(value={BadSqlGrammarException.class})
    public ResponseResult<?> handleBadSqlGrammarException(BadSqlGrammarException e) {
        log.error("SQL\u5f02\u5e38\uff1a", (Throwable)e);
        return ResponseResult.result((int)ResponseInfoStatus.FAILURE.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={PersistenceException.class})
    public ResponseResult<?> persistenceException(PersistenceException e) {
        log.error("\u6570\u636e\u5e93\u5f02\u5e38\uff1a", (Throwable)e);
        if (e.getCause() instanceof BizException) {
            BizException cause = (BizException)e.getCause();
            return ResponseResult.result((int)cause.getCode(), (String)cause.getMessage());
        }
        return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={MyBatisSystemException.class})
    public ResponseResult<?> myBatisSystemException(MyBatisSystemException e) {
        log.error("Mybatis\u5f02\u5e38\uff1a", (Throwable)e);
        if (e.getCause() instanceof PersistenceException) {
            return this.persistenceException((PersistenceException)e.getCause());
        }
        return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)ResponseInfoStatus.SQL_EX.getMessage());
    }

    @ExceptionHandler(value={SQLException.class})
    public ResponseResult<?> sqlException(SQLException e) {
        log.error("SQL\u5f02\u5e38\uff1a", (Throwable)e);
        return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={TenantException.class})
    public ResponseResult<?> handleTenantException(TenantException e) {
        log.error("\u79df\u6237\u5f02\u5e38\uff1a", (Throwable)e);
        return ResponseResult.result((int)e.getCode(), (String)e.getMessage());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public ResponseResult<?> handler(DuplicateKeyException e) {
        log.error("\u6570\u636e\u91cd\u590d\u8f93\u5165: ", (Throwable)e);
        return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)"\u6570\u636e\u91cd\u590d\u8f93\u5165");
    }

    @ExceptionHandler(value={DataIntegrityViolationException.class})
    public ResponseResult<?> handler(DataIntegrityViolationException e) {
        SQLException sqlException;
        int errorCode;
        log.error("\u6570\u636e\u5e93\u64cd\u4f5c\u5f02\u5e38:", (Throwable)e);
        String message = e.getMessage();
        String prefix = "Data too long";
        if (message.contains(prefix)) {
            return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)"\u8f93\u5165\u6570\u636e\u5b57\u6bb5\u8fc7\u957f");
        }
        Throwable cause = e.getCause();
        if (cause instanceof SQLException && (errorCode = (sqlException = (SQLException)cause).getErrorCode()) == 1364) {
            return ResponseResult.result((int)ResponseInfoStatus.SQL_EX.getCode(), (String)"\u6570\u636e\u64cd\u4f5c\u5f02\u5e38,\u8f93\u5165\u53c2\u6570\u4e3a\u7a7a");
        }
        return ResponseResult.result((ResponseInfoStatus)ResponseInfoStatus.SQL_EX);
    }

    public int getOrder() {
        return BeanOrderEnum.DATASOURCE_EXCEPTION_HANDLER_ORDER.getOrder();
    }
}

