/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.extension.hash;

import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Set;

public class ShowHashAlgorithms {
    private static final void showHashAlgorithms(Provider prov, Class<?> typeClass) {
        String type = typeClass.getSimpleName();
        ArrayList<Provider.Service> algos = new ArrayList<Provider.Service>();
        Set<Provider.Service> services = prov.getServices();
        for (Provider.Service service : services) {
            if (!service.getType().equalsIgnoreCase(type)) continue;
            algos.add(service);
        }
        if (!algos.isEmpty()) {
            System.out.printf(" --- Provider %s, version %.2f --- %s", prov.getName(), prov.getVersionStr());
            for (Provider.Service service : algos) {
                String algo = service.getAlgorithm();
                System.out.printf("Algorithm name: \"%s\"%n", algo);
            }
        }
        Set<Object> keys = prov.keySet();
        for (Object key : keys) {
            String prefix = "Alg.Alias." + type + ".";
            if (!key.toString().startsWith(prefix)) continue;
            String value = prov.get(key.toString()).toString();
            System.out.printf("Alias: \"%s\" -> \"%s\"%n", key.toString().substring(prefix.length()), value);
        }
    }

    public static void main(String[] args) {
        Provider[] providers;
        for (Provider provider : providers = Security.getProviders()) {
            ShowHashAlgorithms.showHashAlgorithms(provider, MessageDigest.class);
        }
    }
}

