/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.extension.time;

import com.github.squirrelgrip.extension.time.TimeExtensionsKt;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.AbstractList;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 )2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001)B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0002H\u0096\u0002J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000bJ\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0013\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010!H\u0096\u0002J\b\u0010\"\u001a\u00020#H\u0016J\u0011\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020#H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010$\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006*"}, d2={"Lcom/github/squirrelgrip/extension/time/DateInterval;", "Lkotlin/collections/AbstractList;", "Ljava/time/LocalDate;", "start", "end", "<init>", "(Ljava/time/LocalDate;Ljava/time/LocalDate;)V", "getStart", "()Ljava/time/LocalDate;", "getEnd", "toPeriod", "Ljava/time/Period;", "isBefore", "", "date", "interval", "isAfter", "contains", "element", "abuts", "overlaps", "gap", "overlap", "join", "withPeriodAfterStart", "period", "withPeriodBeforeEnd", "withStart", "withEnd", "toString", "", "equals", "other", "", "hashCode", "", "size", "getSize", "()I", "get", "index", "Companion", "kotlin-extensions-jvm"})
public final class DateInterval
extends AbstractList<LocalDate> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDate start;
    @NotNull
    private final LocalDate end;

    private DateInterval(LocalDate start, LocalDate end) {
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final LocalDate getStart() {
        return this.start;
    }

    @NotNull
    public final LocalDate getEnd() {
        return this.end;
    }

    @NotNull
    public final Period toPeriod() {
        Period period = Period.between(this.start, this.end);
        Intrinsics.checkNotNullExpressionValue((Object)period, (String)"between(...)");
        return period;
    }

    public final boolean isBefore(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return TimeExtensionsKt.isEqualOrBefore(this.end, date);
    }

    public final boolean isBefore(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return this.isBefore(interval.start);
    }

    public final boolean isAfter(@NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return this.start.isAfter(date);
    }

    public final boolean isAfter(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return TimeExtensionsKt.isEqualOrAfter(this.start, interval.end);
    }

    public boolean contains(@NotNull LocalDate element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return TimeExtensionsKt.isEqualOrAfter(element, this.start) && element.isBefore(this.end);
    }

    public final boolean abuts(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return Intrinsics.areEqual((Object)interval.end, (Object)this.start) || Intrinsics.areEqual((Object)interval.start, (Object)this.end);
    }

    public final boolean overlaps(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return this.contains((Object)interval.start) || this.contains((Object)interval.end) || interval.contains((Object)this.start) && interval.contains((Object)this.end);
    }

    public final boolean contains(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return this.contains((Object)interval.start) && TimeExtensionsKt.isEqualOrBefore(interval.end, this.end);
    }

    @Nullable
    public final DateInterval gap(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        return this.abuts(interval) || this.overlaps(interval) ? null : (this.isBefore(interval) ? Companion.of(this.end, interval.start) : Companion.of(interval.end, this.start));
    }

    @Nullable
    public final DateInterval overlap(@NotNull DateInterval interval) {
        DateInterval dateInterval;
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        if (this.overlaps(interval)) {
            LocalDate tempStart = this.start.isBefore(interval.start) ? interval.start : this.start;
            LocalDate tempEnd = interval.end.isAfter(this.end) ? this.end : interval.end;
            dateInterval = Companion.of(tempStart, tempEnd);
        } else {
            dateInterval = null;
        }
        return dateInterval;
    }

    @Nullable
    public final DateInterval join(@NotNull DateInterval interval) {
        Intrinsics.checkNotNullParameter((Object)((Object)interval), (String)"interval");
        if (!this.abuts(interval) && !this.overlaps(interval)) {
            throw new IllegalArgumentException("Interval does not abut or overlap.");
        }
        LocalDate tempStart = this.start.isBefore(interval.start) ? this.start : interval.start;
        LocalDate tempEnd = interval.end.isAfter(this.end) ? interval.end : this.end;
        return Companion.of(tempStart, tempEnd);
    }

    @NotNull
    public final DateInterval withPeriodAfterStart(@NotNull Period period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return Companion.of(this.start, period);
    }

    @NotNull
    public final DateInterval withPeriodBeforeEnd(@NotNull Period period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return Companion.of(period, this.end);
    }

    @NotNull
    public final DateInterval withStart(@NotNull LocalDate start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        return Companion.of(start, this.end);
    }

    @NotNull
    public final DateInterval withEnd(@NotNull LocalDate end) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return Companion.of(this.start, end);
    }

    @NotNull
    public String toString() {
        return this.start + "/" + this.end;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else {
            Object object = other;
            if (!Intrinsics.areEqual(((Object)((Object)this)).getClass(), object != null ? object.getClass() : null)) {
                bl = false;
            } else {
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.github.squirrelgrip.extension.time.DateInterval");
                DateInterval cfr_ignored_0 = (DateInterval)((Object)other);
                bl = Intrinsics.areEqual((Object)this.start, (Object)((DateInterval)((Object)other)).start) && Intrinsics.areEqual((Object)this.end, (Object)((DateInterval)((Object)other)).end);
            }
        }
        return bl;
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    public int getSize() {
        return (int)(this.end.toEpochDay() - this.start.toEpochDay());
    }

    @NotNull
    public LocalDate get(int index) {
        Objects.checkIndex(index, this.size());
        LocalDate localDate = this.start.plusDays(index);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"plusDays(...)");
        return localDate;
    }

    public /* synthetic */ DateInterval(LocalDate start, LocalDate end, DefaultConstructorMarker $constructor_marker) {
        this(start, end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013\u00a8\u0006\u0016"}, d2={"Lcom/github/squirrelgrip/extension/time/DateInterval$Companion;", "", "<init>", "()V", "of", "Lcom/github/squirrelgrip/extension/time/DateInterval;", "start", "Ljava/time/LocalDate;", "end", "period", "Ljava/time/Period;", "duration", "Ljava/time/Duration;", "parse", "str", "", "subListRangeCheck", "", "fromIndex", "", "toIndex", "size", "kotlin-extensions-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateInterval of(@NotNull LocalDate start, @NotNull LocalDate end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (!TimeExtensionsKt.isEqualOrBefore(start, end)) {
                throw new IllegalArgumentException("Start is after end");
            }
            return new DateInterval(start, end, null);
        }

        @NotNull
        public final DateInterval of(@NotNull LocalDate start, @NotNull Period period) {
            DateInterval dateInterval;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            if (period.isNegative()) {
                LocalDate localDate = start.plus(period);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"plus(...)");
                dateInterval = this.of(localDate, start);
            } else {
                LocalDate localDate = start.plus(period);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"plus(...)");
                dateInterval = this.of(start, localDate);
            }
            return dateInterval;
        }

        @NotNull
        public final DateInterval of(@NotNull Period period, @NotNull LocalDate end) {
            DateInterval dateInterval;
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (period.isNegative()) {
                LocalDate localDate = end.minus(period);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minus(...)");
                dateInterval = this.of(end, localDate);
            } else {
                LocalDate localDate = end.minus(period);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minus(...)");
                dateInterval = this.of(localDate, end);
            }
            return dateInterval;
        }

        @NotNull
        public final DateInterval of(@NotNull Duration duration, @NotNull LocalDate end) {
            DateInterval dateInterval;
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (duration.isNegative()) {
                LocalDate localDate = end.minus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minus(...)");
                dateInterval = this.of(end, localDate);
            } else {
                LocalDate localDate = end.minus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"minus(...)");
                dateInterval = this.of(localDate, end);
            }
            return dateInterval;
        }

        @NotNull
        public final DateInterval parse(@NotNull String str) {
            DateInterval dateInterval;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Object object = new String[]{"/"};
            List split = StringsKt.split$default((CharSequence)str, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = (CharSequence)split.get(0);
            if (new Regex("[-+]?P.*").matches((CharSequence)object)) {
                Period period = Period.parse((CharSequence)split.get(0));
                Intrinsics.checkNotNullExpressionValue((Object)period, (String)"parse(...)");
                LocalDate localDate = LocalDate.parse((CharSequence)split.get(1));
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
                dateInterval = this.of(period, localDate);
            } else {
                object = (CharSequence)split.get(1);
                if (new Regex("[-+]?P.*").matches((CharSequence)object)) {
                    LocalDate localDate = LocalDate.parse((CharSequence)split.get(0));
                    Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
                    Period period = Period.parse((CharSequence)split.get(1));
                    Intrinsics.checkNotNullExpressionValue((Object)period, (String)"parse(...)");
                    dateInterval = this.of(localDate, period);
                } else {
                    LocalDate localDate = LocalDate.parse((CharSequence)split.get(0));
                    Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"parse(...)");
                    LocalDate localDate2 = LocalDate.parse((CharSequence)split.get(1));
                    Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"parse(...)");
                    dateInterval = this.of(localDate, localDate2);
                }
            }
            return dateInterval;
        }

        public final void subListRangeCheck(int fromIndex, int toIndex, int size) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > size) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

