/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.extension.time;

import com.github.squirrelgrip.extension.time.TimeExtensionsKt;
import java.time.Duration;
import java.time.Instant;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.temporal.Temporal;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000bJ\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\b\u0010 \u001a\u00020!H\u0016J\u0013\u0010\"\u001a\u00020\r2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006'"}, d2={"Lcom/github/squirrelgrip/extension/time/Interval;", "", "start", "Ljava/time/Instant;", "end", "<init>", "(Ljava/time/Instant;Ljava/time/Instant;)V", "getStart", "()Ljava/time/Instant;", "getEnd", "toDuration", "Ljava/time/Duration;", "isBefore", "", "instant", "interval", "isAfter", "contains", "abuts", "overlaps", "gap", "overlap", "join", "withDurationAfterStart", "duration", "withDurationBeforeEnd", "withPeriodAfterStart", "period", "Ljava/time/Period;", "withPeriodBeforeEnd", "withStart", "withEnd", "toString", "", "equals", "other", "hashCode", "", "Companion", "kotlin-extensions-jvm"})
public final class Interval {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Instant start;
    @NotNull
    private final Instant end;

    private Interval(Instant start, Instant end) {
        this.start = start;
        this.end = end;
    }

    @NotNull
    public final Instant getStart() {
        return this.start;
    }

    @NotNull
    public final Instant getEnd() {
        return this.end;
    }

    @NotNull
    public final Duration toDuration() {
        Duration duration = Duration.between(this.start, this.end);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
        return duration;
    }

    public final boolean isBefore(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return TimeExtensionsKt.isEqualOrBefore(this.end, instant);
    }

    public final boolean isBefore(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.isBefore(interval.start);
    }

    public final boolean isAfter(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return this.start.isAfter(instant);
    }

    public final boolean isAfter(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return TimeExtensionsKt.isEqualOrAfter(this.start, interval.end);
    }

    public final boolean contains(@NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return TimeExtensionsKt.isEqualOrAfter(instant, this.start) && instant.isBefore(this.end);
    }

    public final boolean abuts(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return Intrinsics.areEqual((Object)interval.end, (Object)this.start) || Intrinsics.areEqual((Object)interval.start, (Object)this.end);
    }

    public final boolean overlaps(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.contains(interval.start) || this.contains(interval.end) || interval.contains(this.start) && interval.contains(this.end);
    }

    public final boolean contains(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.contains(interval.start) && TimeExtensionsKt.isEqualOrBefore(interval.end, this.end);
    }

    @Nullable
    public final Interval gap(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        return this.abuts(interval) || this.overlaps(interval) ? null : (this.isBefore(interval) ? com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, this.end, interval.start, null, 4, null) : com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, interval.end, this.start, null, 4, null));
    }

    @Nullable
    public final Interval overlap(@NotNull Interval interval) {
        Interval interval2;
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        if (this.overlaps(interval)) {
            Instant start = this.start.isBefore(interval.start) ? interval.start : this.start;
            Instant end = interval.end.isAfter(this.end) ? this.end : interval.end;
            interval2 = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, start, end, null, 4, null);
        } else {
            interval2 = null;
        }
        return interval2;
    }

    @NotNull
    public final Interval join(@NotNull Interval interval) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        if (!this.abuts(interval) && !this.overlaps(interval)) {
            throw new IllegalArgumentException("Interval does not abut or overlap.");
        }
        Instant start = this.start.isBefore(interval.start) ? this.start : interval.start;
        Instant end = interval.end.isAfter(this.end) ? interval.end : this.end;
        return com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, start, end, null, 4, null);
    }

    @NotNull
    public final Interval withDurationAfterStart(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return Companion.of((Temporal)this.start, duration);
    }

    @NotNull
    public final Interval withDurationBeforeEnd(@NotNull Duration duration) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        return Companion.of(duration, (Temporal)this.end);
    }

    @NotNull
    public final Interval withPeriodAfterStart(@NotNull Period period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return Companion.of((Temporal)this.start, period);
    }

    @NotNull
    public final Interval withPeriodBeforeEnd(@NotNull Period period) {
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        return Companion.of(period, (Temporal)this.end);
    }

    @NotNull
    public final Interval withStart(@NotNull Instant start) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        return com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, start, this.end, null, 4, null);
    }

    @NotNull
    public final Interval withEnd(@NotNull Instant end) {
        Intrinsics.checkNotNullParameter((Object)end, (String)"end");
        return com.github.squirrelgrip.extension.time.Interval$Companion.of$default(Companion, this.start, end, null, 4, null);
    }

    @NotNull
    public String toString() {
        return this.start + "/" + this.end;
    }

    public boolean equals(@Nullable Object other) {
        boolean bl;
        if (this == other) {
            bl = true;
        } else {
            Object object = other;
            if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
                bl = false;
            } else {
                Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.github.squirrelgrip.extension.time.Interval");
                Interval cfr_ignored_0 = (Interval)other;
                bl = Intrinsics.areEqual((Object)this.start, (Object)((Interval)other).start) && Intrinsics.areEqual((Object)this.end, (Object)((Interval)other).end);
            }
        }
        return bl;
    }

    public int hashCode() {
        return 31 * this.start.hashCode() + this.end.hashCode();
    }

    public /* synthetic */ Interval(Instant start, Instant end, DefaultConstructorMarker $constructor_marker) {
        this(start, end);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lcom/github/squirrelgrip/extension/time/Interval$Companion;", "", "<init>", "()V", "of", "Lcom/github/squirrelgrip/extension/time/Interval;", "start", "Ljava/time/temporal/Temporal;", "end", "zone", "Ljava/time/ZoneOffset;", "period", "Ljava/time/Period;", "duration", "Ljava/time/Duration;", "parse", "str", "", "kotlin-extensions-jvm"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Interval of(@NotNull Temporal start, @NotNull Temporal end, @NotNull ZoneOffset zone) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
            Instant startInstant = TimeExtensionsKt.toInstant$default(start, zone, null, null, 6, null);
            Instant endInstant = TimeExtensionsKt.toInstant$default(end, zone, null, null, 6, null);
            if (!TimeExtensionsKt.isEqualOrBefore(startInstant, endInstant)) {
                throw new IllegalArgumentException("Start is after end");
            }
            return new Interval(startInstant, endInstant, null);
        }

        public static /* synthetic */ Interval of$default(Companion companion, Temporal temporal, Temporal temporal2, ZoneOffset zoneOffset, int n, Object object) {
            if ((n & 4) != 0) {
                zoneOffset = ZoneOffset.UTC;
            }
            return companion.of(temporal, temporal2, zoneOffset);
        }

        @NotNull
        public final Interval of(@NotNull Temporal start, @NotNull Period period) {
            Interval interval;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            if (period.isNegative()) {
                Temporal temporal = start.plus(period);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"plus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, temporal, start, null, 4, null);
            } else {
                Temporal temporal = start.plus(period);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"plus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, start, temporal, null, 4, null);
            }
            return interval;
        }

        @NotNull
        public final Interval of(@NotNull Period period, @NotNull Temporal end) {
            Interval interval;
            Intrinsics.checkNotNullParameter((Object)period, (String)"period");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (period.isNegative()) {
                Temporal temporal = end.minus(period);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"minus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, end, temporal, null, 4, null);
            } else {
                Temporal temporal = end.minus(period);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"minus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, temporal, end, null, 4, null);
            }
            return interval;
        }

        @NotNull
        public final Interval of(@NotNull Temporal start, @NotNull Duration duration) {
            Interval interval;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            if (duration.isNegative()) {
                Temporal temporal = start.plus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"plus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, temporal, start, null, 4, null);
            } else {
                Temporal temporal = start.plus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"plus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, start, temporal, null, 4, null);
            }
            return interval;
        }

        @NotNull
        public final Interval of(@NotNull Duration duration, @NotNull Temporal end) {
            Interval interval;
            Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            if (duration.isNegative()) {
                Temporal temporal = end.minus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"minus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, end, temporal, null, 4, null);
            } else {
                Temporal temporal = end.minus(duration);
                Intrinsics.checkNotNullExpressionValue((Object)temporal, (String)"minus(...)");
                interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, temporal, end, null, 4, null);
            }
            return interval;
        }

        @NotNull
        public final Interval parse(@NotNull String str) {
            Interval interval;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            Object object = new String[]{"/"};
            List split = StringsKt.split$default((CharSequence)str, (String[])object, (boolean)false, (int)0, (int)6, null);
            object = (CharSequence)split.get(0);
            if (new Regex("[-+]?P.*").matches((CharSequence)object)) {
                Duration duration = Duration.parse((CharSequence)split.get(0));
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
                Instant instant = Instant.parse((CharSequence)split.get(1));
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
                interval = this.of(duration, (Temporal)instant);
            } else {
                object = (CharSequence)split.get(1);
                if (new Regex("[-+]?P.*").matches((CharSequence)object)) {
                    Instant instant = Instant.parse((CharSequence)split.get(0));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
                    Temporal temporal = instant;
                    Duration duration = Duration.parse((CharSequence)split.get(1));
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
                    interval = this.of(temporal, duration);
                } else {
                    Instant instant = Instant.parse((CharSequence)split.get(0));
                    Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"parse(...)");
                    Temporal temporal = instant;
                    Instant instant2 = Instant.parse((CharSequence)split.get(1));
                    Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"parse(...)");
                    interval = com.github.squirrelgrip.extension.time.Interval$Companion.of$default(this, temporal, instant2, null, 4, null);
                }
            }
            return interval;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

