/*
 * Decompiled with CFR 0.152.
 */
package com.github.squirrelgrip.extension.time;

import com.github.squirrelgrip.extension.time.DateInterval;
import com.github.squirrelgrip.extension.time.Interval;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.chrono.ChronoLocalDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0007\u001a\u0014\u0010\b\u001a\u00020\u0006*\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\t\u001a\u00020\u0007*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\u0003*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\r\u001a\u00020\u000e*\u00020\u00022\b\b\u0002\u0010\n\u001a\u00020\u000b\u001a(\u0010\u000f\u001a\u00020\u0002*\u00020\u00102\b\b\u0002\u0010\n\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\u000e2\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002\u001a\u0012\u0010\u0017\u001a\u00020\u0015*\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u0002\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e\u001a\u0012\u0010\u0017\u001a\u00020\u0015*\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u000e\u001a\u0014\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\u001c"}, d2={"toDate", "Ljava/util/Date;", "Ljava/time/Instant;", "Ljava/time/LocalDateTime;", "offset", "Ljava/time/ZoneOffset;", "Ljava/time/OffsetDateTime;", "Ljava/time/ZonedDateTime;", "toOffsetDateTime", "toZonedDateTime", "zone", "Ljava/time/ZoneId;", "toLocalDateTime", "toLocalDate", "Ljava/time/LocalDate;", "toInstant", "Ljava/time/temporal/Temporal;", "atDate", "atTime", "Ljava/time/LocalTime;", "isEqualOrBefore", "", "instant", "isEqualOrAfter", "date", "toInterval", "Lcom/github/squirrelgrip/extension/time/Interval;", "Lcom/github/squirrelgrip/extension/time/DateInterval;", "kotlin-extensions-jvm"})
public final class TimeExtensionsKt {
    @NotNull
    public static final Date toDate(@NotNull Instant $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        return new Date($this$toDate.toEpochMilli());
    }

    @NotNull
    public static final Date toDate(@NotNull LocalDateTime $this$toDate, @NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Instant instant = $this$toDate.toInstant(offset);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return TimeExtensionsKt.toDate(instant);
    }

    public static /* synthetic */ Date toDate$default(LocalDateTime localDateTime, ZoneOffset zoneOffset, int n, Object object) {
        if ((n & 1) != 0) {
            zoneOffset = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toDate(localDateTime, zoneOffset);
    }

    @NotNull
    public static final Date toDate(@NotNull OffsetDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Instant instant = $this$toDate.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return TimeExtensionsKt.toDate(instant);
    }

    @NotNull
    public static final Date toDate(@NotNull ZonedDateTime $this$toDate) {
        Intrinsics.checkNotNullParameter((Object)$this$toDate, (String)"<this>");
        Instant instant = $this$toDate.toInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"toInstant(...)");
        return TimeExtensionsKt.toDate(instant);
    }

    @NotNull
    public static final OffsetDateTime toOffsetDateTime(@NotNull Instant $this$toOffsetDateTime, @NotNull ZoneOffset offset) {
        Intrinsics.checkNotNullParameter((Object)$this$toOffsetDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        OffsetDateTime offsetDateTime = $this$toOffsetDateTime.atOffset(offset);
        Intrinsics.checkNotNullExpressionValue((Object)offsetDateTime, (String)"atOffset(...)");
        return offsetDateTime;
    }

    public static /* synthetic */ OffsetDateTime toOffsetDateTime$default(Instant instant, ZoneOffset zoneOffset, int n, Object object) {
        if ((n & 1) != 0) {
            zoneOffset = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toOffsetDateTime(instant, zoneOffset);
    }

    @NotNull
    public static final ZonedDateTime toZonedDateTime(@NotNull Instant $this$toZonedDateTime, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toZonedDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        ZonedDateTime zonedDateTime = $this$toZonedDateTime.atZone(zone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atZone(...)");
        return zonedDateTime;
    }

    public static /* synthetic */ ZonedDateTime toZonedDateTime$default(Instant instant, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toZonedDateTime(instant, zoneId);
    }

    @NotNull
    public static final LocalDateTime toLocalDateTime(@NotNull Instant $this$toLocalDateTime, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        LocalDateTime localDateTime = LocalDateTime.ofInstant($this$toLocalDateTime, zone);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"ofInstant(...)");
        return localDateTime;
    }

    public static /* synthetic */ LocalDateTime toLocalDateTime$default(Instant instant, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toLocalDateTime(instant, zoneId);
    }

    @NotNull
    public static final LocalDate toLocalDate(@NotNull Instant $this$toLocalDate, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        LocalDate localDate = LocalDate.ofInstant($this$toLocalDate, zone);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofInstant(...)");
        return localDate;
    }

    public static /* synthetic */ LocalDate toLocalDate$default(Instant instant, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toLocalDate(instant, zoneId);
    }

    @NotNull
    public static final Instant toInstant(@NotNull Temporal $this$toInstant, @NotNull ZoneOffset zone, @NotNull LocalDate atDate, @NotNull LocalTime atTime) {
        Instant instant;
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        Intrinsics.checkNotNullParameter((Object)atDate, (String)"atDate");
        Intrinsics.checkNotNullParameter((Object)atTime, (String)"atTime");
        Temporal temporal = $this$toInstant;
        if (temporal instanceof ChronoLocalDate) {
            Instant instant2 = ((ChronoLocalDate)$this$toInstant).atTime(atTime).toInstant(zone);
            instant = instant2;
            Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"toInstant(...)");
        } else if (temporal instanceof ChronoLocalDateTime) {
            Instant instant3 = ((ChronoLocalDateTime)$this$toInstant).toInstant(zone);
            instant = instant3;
            Intrinsics.checkNotNullExpressionValue((Object)instant3, (String)"toInstant(...)");
        } else if (temporal instanceof ChronoZonedDateTime) {
            Instant instant4 = ((ChronoZonedDateTime)$this$toInstant).toInstant();
            instant = instant4;
            Intrinsics.checkNotNullExpressionValue((Object)instant4, (String)"toInstant(...)");
        } else if (temporal instanceof Instant) {
            instant = (Instant)$this$toInstant;
        } else if (temporal instanceof LocalTime) {
            OffsetTime offsetTime = ((LocalTime)$this$toInstant).atOffset(zone);
            Intrinsics.checkNotNullExpressionValue((Object)offsetTime, (String)"atOffset(...)");
            instant = TimeExtensionsKt.toInstant$default(offsetTime, zone, atDate, null, 4, null);
        } else if (temporal instanceof OffsetDateTime) {
            Instant instant5 = ((OffsetDateTime)$this$toInstant).toInstant();
            instant = instant5;
            Intrinsics.checkNotNullExpressionValue((Object)instant5, (String)"toInstant(...)");
        } else if (temporal instanceof OffsetTime) {
            Instant instant6 = ((OffsetTime)$this$toInstant).atDate(atDate).toInstant();
            instant = instant6;
            Intrinsics.checkNotNullExpressionValue((Object)instant6, (String)"toInstant(...)");
        } else if (temporal instanceof Year) {
            YearMonth yearMonth = ((Year)$this$toInstant).atMonth(atDate.getMonth());
            Intrinsics.checkNotNullExpressionValue((Object)yearMonth, (String)"atMonth(...)");
            instant = TimeExtensionsKt.toInstant(yearMonth, zone, atDate, atTime);
        } else if (temporal instanceof YearMonth) {
            LocalDate localDate = ((YearMonth)$this$toInstant).atDay(Integer.min(((YearMonth)$this$toInstant).lengthOfMonth(), atDate.getDayOfMonth()));
            Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atDay(...)");
            instant = TimeExtensionsKt.toInstant(localDate, zone, atDate, atTime);
        } else {
            throw new UnsupportedOperationException();
        }
        return instant;
    }

    public static /* synthetic */ Instant toInstant$default(Temporal temporal, ZoneOffset zoneOffset, LocalDate localDate, LocalTime localTime, int n, Object object) {
        if ((n & 1) != 0) {
            zoneOffset = ZoneOffset.UTC;
        }
        if ((n & 2) != 0) {
            localDate = LocalDate.now(zoneOffset);
        }
        if ((n & 4) != 0) {
            localTime = LocalTime.now(zoneOffset);
        }
        return TimeExtensionsKt.toInstant(temporal, zoneOffset, localDate, localTime);
    }

    public static final boolean isEqualOrBefore(@NotNull Instant $this$isEqualOrBefore, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return !$this$isEqualOrBefore.isAfter(instant);
    }

    public static final boolean isEqualOrAfter(@NotNull Instant $this$isEqualOrAfter, @NotNull Instant instant) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        return !$this$isEqualOrAfter.isBefore(instant);
    }

    public static final boolean isEqualOrBefore(@NotNull LocalDate $this$isEqualOrBefore, @NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrBefore, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return !$this$isEqualOrBefore.isAfter(date);
    }

    public static final boolean isEqualOrAfter(@NotNull LocalDate $this$isEqualOrAfter, @NotNull LocalDate date) {
        Intrinsics.checkNotNullParameter((Object)$this$isEqualOrAfter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        return !$this$isEqualOrAfter.isBefore(date);
    }

    @NotNull
    public static final Interval toInterval(@NotNull DateInterval $this$toInterval, @NotNull ZoneId zone) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toInterval), (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)zone, (String)"zone");
        ZonedDateTime zonedDateTime = $this$toInterval.getStart().atStartOfDay(zone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime, (String)"atStartOfDay(...)");
        Temporal temporal = zonedDateTime;
        ZonedDateTime zonedDateTime2 = $this$toInterval.getEnd().atStartOfDay(zone);
        Intrinsics.checkNotNullExpressionValue((Object)zonedDateTime2, (String)"atStartOfDay(...)");
        return Interval.Companion.of$default(Interval.Companion, temporal, zonedDateTime2, null, 4, null);
    }

    public static /* synthetic */ Interval toInterval$default(DateInterval dateInterval, ZoneId zoneId, int n, Object object) {
        if ((n & 1) != 0) {
            zoneId = ZoneOffset.UTC;
        }
        return TimeExtensionsKt.toInterval(dateInterval, zoneId);
    }
}

